//
//  TestGLView.m
//  testapp
//
//  Created by Torsten Kammer on 19.04.11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "TestGLView.h"

#import <OpenGL/gl.h>

@interface TestGLView ()

- (void)loadTexture;
- (void)load3DObject;
- (void)draw3DObject;
- (void)loadCoreImage;
- (void)drawCoreImage;

@end

@implementation TestGLView

- (void)prepareOpenGL;
{
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	
	// Für Texturen
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glEnable(GL_TEXTURE_RECTANGLE_ARB);
	
	[self loadTexture];
	[self load3DObject];
	[self loadCoreImage];
}

- (void)reshape;
{	
	NSRect bounds = [self bounds];
	
	glViewport(0, 0, bounds.size.width, bounds.size.height);
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	//glOrtho(0.0, bounds.size.width, 0.0, bounds.size.height, -1.0, 1.0);
	glFrustum(-bounds.size.width / bounds.size.height, bounds.size.width / bounds.size.height, -1.0, 1.0, 0.01, 10.0);
	glMatrixMode(GL_MODELVIEW);
}

- (void)drawRect:(NSRect)dirtyRect
{	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	glLoadIdentity();
	
	float data[] = {
		40.0, 40.0,		0.5, 1.0, 0.0,	0.0, 0.0,
		200.0, 200.0,	1.0, 0.0, 0.5,	64.0, 0.0,
		600.0, 40.0,	0.0, 0.5, 1.0,	64.0, 64.0
	};
	glVertexPointer(2, GL_FLOAT, sizeof(float [7]), data);
	glColorPointer(3, GL_FLOAT, sizeof(float [7]), &(data[2]));
	glTexCoordPointer(2, GL_FLOAT, sizeof(float [7]), &(data[5]));
	
	glBindTexture(GL_TEXTURE_RECTANGLE_ARB, texture);
	
	glTranslatef(-40.0f, -40.0f, 0.0f);
	glRotatef(23.0f, 0.0f, 0.0f, 1.0f);
	glTranslatef(40.0f, 40.0f, 0.0f);
	
	glDrawArrays(GL_TRIANGLES, 0, 3);
	
	[self draw3DObject];
	[self drawCoreImage];
	
	[[self openGLContext] flushBuffer];
}




- (void)loadTexture
{
	const char data[] = { 0x7A, 0xB1, 0xF9, 0x78, 0xB3, 0xF8, 0x78, 0xB2, 0xF7, 0x78, 0xB2, 0xF7, 0x77, 0xB3, 0xF8, 0x79, 0xB1, 0xF8, 0x7D, 0xB1, 0xF9, 0x7E, 0xB1, 0xFA, 0x7B, 0xB2, 0xF9, 0x79, 0xB4, 0xF8, 0x78, 0xB2, 0xF7, 0x79, 0xB2, 0xF9, 0x79, 0xB2, 0xF9, 0x7B, 0xB2, 0xF9, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF9, 0x7B, 0xB2, 0xF8, 0x79, 0xB2, 0xF7, 0x78, 0xB2, 0xF7, 0x79, 0xB2, 0xF7, 0x79, 0xB3, 0xF8, 0x78, 0xB1, 0xF7, 0x79, 0xB2, 0xF8, 0x7A, 0xB3, 0xF9, 0x7B, 0xB2, 0xF9, 0x7C, 0xB2, 0xFA, 0x7A, 0xB2, 0xF8, 0x78, 0xB2, 0xF8, 0x7B, 0xB2, 0xF9, 0x7C, 0xB2, 0xFA, 0x79, 0xB2, 0xF9, 0x79, 0xB3, 0xF7, 0x79, 0xB4, 0xF8, 0x7B, 0xB2, 0xF8, 0x7D, 0xB3, 0xFA, 0x7B, 0xB2, 0xF8, 0x7B, 0xB1, 0xF7, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7B, 0xB2, 0xF9, 0x79, 0xB2, 0xF8, 0x79, 0xB2, 0xF7, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF9, 0x7C, 0xB2, 0xFA, 0x7A, 0xB3, 0xFA, 0x7A, 0xB2, 0xF9, 0x7C, 0xB2, 0xFA, 0x7C, 0xB3, 0xFA, 0x7C, 0xB2, 0xF9, 0x7C, 0xB2, 0xF7, 0x7C, 0xB3, 0xF8, 0x7B, 0xB2, 0xF8, 0x7A, 0xB2, 0xF8, 0x7B, 0xB2, 0xF9, 0x7A, 0xB2, 0xF8, 0x7A, 0xB2, 0xF7, 0x7B, 0xB3, 0xF8, 0x7A, 0xB2, 0xF9, 0x79, 0xB2, 0xFA, 0x7B, 0xB2, 0xFC, 0x7A, 0xB1, 0xF9, 0x7D, 0xB0, 0xFA, 0x79, 0xB3, 0xF8, 0x77, 0xB2, 0xF6, 0x7A, 0xB2, 0xF7, 0x7A, 0xB1, 0xF7, 0x7C, 0xB1, 0xF7, 0x7E, 0xB2, 0xF8, 0x7F, 0xB1, 0xFA, 0x7C, 0xB1, 0xF9, 0x79, 0xB4, 0xF8, 0x78, 0xB4, 0xF7, 0x79, 0xB3, 0xF8, 0x79, 0xB2, 0xF8, 0x78, 0xB1, 0xF7, 0x79, 0xB2, 0xF8, 0x79, 0xB3, 0xF9, 0x79, 0xB1, 0xF7, 0x77, 0xB2, 0xF8, 0x79, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x7A, 0xB2, 0xF7, 0x78, 0xB1, 0xF8, 0x78, 0xB0, 0xFB, 0x79, 0xB1, 0xF8, 0x79, 0xB3, 0xF7, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7B, 0xB1, 0xF7, 0x7C, 0xB1, 0xF7, 0x7A, 0xB3, 0xF9, 0x78, 0xB2, 0xF9, 0x7B, 0xB1, 0xF7, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7A, 0xB3, 0xFA, 0x7B, 0xB2, 0xF9, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7B, 0xB2, 0xF8, 0x79, 0xB3, 0xF8, 0x79, 0xB3, 0xF7, 0x79, 0xB2, 0xF8, 0x7A, 0xB2, 0xFA, 0x7C, 0xB2, 0xFA, 0x7C, 0xB2, 0xFA, 0x7B, 0xB0, 0xF9, 0x7D, 0xB2, 0xFA, 0x7B, 0xB1, 0xF8, 0x7C, 0xB2, 0xF7, 0x7B, 0xB3, 0xFA, 0x7A, 0xB3, 0xFA, 0x79, 0xB2, 0xF9, 0x7A, 0xB3, 0xF8, 0x79, 0xB4, 0xF8, 0x79, 0xB2, 0xF7, 0x7C, 0xB1, 0xF8, 0x7D, 0xB1, 0xF9, 0x7E, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7A, 0xB3, 0xF9, 0x7B, 0xB2, 0xFA, 0x7D, 0xB1, 0xFA, 0x7B, 0xB3, 0xFA, 0x78, 0xB2, 0xF8, 0x7D, 0xB2, 0xF8, 0x7A, 0xB1, 0xF7, 0x78, 0xB2, 0xF6, 0x7A, 0xB3, 0xF8, 0x7B, 0xB1, 0xF8, 0x7C, 0xB2, 0xF9, 0x7D, 0xB2, 0xF8, 0x7C, 0xB0, 0xF9, 0x79, 0xB2, 0xF9, 0x78, 0xB3, 0xF7, 0x7A, 0xB2, 0xF7, 0x7A, 0xB2, 0xF7, 0x79, 0xB2, 0xF7, 0x79, 0xB2, 0xF7, 0x79, 0xB2, 0xF7, 0x7A, 0xB3, 0xF8, 0x7B, 0xB1, 0xF8, 0x79, 0xB3, 0xF8, 0x79, 0xB3, 0xF7, 0x7C, 0xB2, 0xF8, 0x7B, 0xB3, 0xF8, 0x78, 0xB2, 0xF8, 0x79, 0xB1, 0xF9, 0x7A, 0xB3, 0xF9, 0x79, 0xB2, 0xF7, 0x79, 0xB2, 0xF7, 0x7A, 0xB1, 0xF7, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7A, 0xB3, 0xF8, 0x79, 0xB2, 0xF8, 0x79, 0xB2, 0xF7, 0x7B, 0xB2, 0xF8, 0x7C, 0xB2, 0xF9, 0x79, 0xB2, 0xF9, 0x7B, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7B, 0xB2, 0xF8, 0x79, 0xB2, 0xF7, 0x79, 0xB3, 0xF7, 0x78, 0xB4, 0xF8, 0x79, 0xB4, 0xF8, 0x7A, 0xB3, 0xF9, 0x7B, 0xB3, 0xF9, 0x7D, 0xB2, 0xF9, 0x7D, 0xB2, 0xF9, 0x7E, 0xB2, 0xF9, 0x7C, 0xB1, 0xF8, 0x7B, 0xB2, 0xF7, 0x7A, 0xB3, 0xF9, 0x79, 0xB2, 0xF9, 0x7A, 0xB3, 0xF8, 0x79, 0xB2, 0xF7, 0x79, 0xB3, 0xF8, 0x79, 0xB2, 0xF7, 0x7C, 0xB2, 0xF8, 0x7E, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7B, 0xB2, 0xF7, 0x79, 0xB2, 0xF8, 0x7B, 0xB2, 0xFA, 0x7C, 0xB2, 0xFA, 0x7A, 0xB4, 0xFA, 0x78, 0xB4, 0xFA, 0x7D, 0xB2, 0xF6, 0x7B, 0xB2, 0xF5, 0x7A, 0xB2, 0xF7, 0x7A, 0xB3, 0xF9, 0x7A, 0xB3, 0xFA, 0x7B, 0xB1, 0xF7, 0x7B, 0xB1, 0xF7, 0x7A, 0xB1, 0xF9, 0x78, 0xB3, 0xF9, 0x78, 0xB3, 0xF7, 0x7E, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x79, 0xB2, 0xF7, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7C, 0xB2, 0xF8, 0x7C, 0xB1, 0xF8, 0x7A, 0xB3, 0xF7, 0x79, 0xB2, 0xF7, 0x7B, 0xB2, 0xF8, 0x79, 0xB3, 0xF8, 0x78, 0xB3, 0xF7, 0x79, 0xB3, 0xF8, 0x7A, 0xB3, 0xF9, 0x79, 0xB2, 0xF9, 0x7B, 0xB3, 0xF8, 0x7C, 0xB2, 0xF8, 0x7B, 0xB1, 0xF7, 0x7C, 0xB2, 0xF7, 0x79, 0xB1, 0xF7, 0x79, 0xB3, 0xF8, 0x79, 0xB2, 0xF7, 0x7A, 0xB3, 0xF9, 0x7A, 0xB3, 0xFA, 0x7A, 0xB3, 0xFA, 0x7C, 0xB2, 0xF9, 0x7D, 0xB2, 0xF8, 0x7B, 0xB2, 0xF8, 0x79, 0xB3, 0xF8, 0x79, 0xB4, 0xF8, 0x78, 0xB5, 0xF8, 0x79, 0xB4, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB2, 0xF7, 0x7D, 0xB3, 0xF9, 0x7D, 0xB2, 0xF8, 0x7F, 0xB2, 0xF8, 0x7E, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7C, 0xB3, 0xF9, 0x79, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x78, 0xB3, 0xF7, 0x79, 0xB4, 0xF8, 0x7A, 0xB3, 0xF8, 0x7C, 0xB2, 0xF8, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x7A, 0xB3, 0xF8, 0x7C, 0xB3, 0xF8, 0x7C, 0xB2, 0xF8, 0x7A, 0xB4, 0xF9, 0x7A, 0xB6, 0xF9, 0x7C, 0xB2, 0xF7, 0x7C, 0xB2, 0xF7, 0x7C, 0xB2, 0xF8, 0x79, 0xB2, 0xF7, 0x78, 0xB2, 0xF8, 0x7A, 0xB2, 0xF8, 0x7C, 0xB2, 0xF9, 0x7B, 0xB2, 0xF9, 0x79, 0xB3, 0xF9, 0x7A, 0xB3, 0xF8, 0x7F, 0xB2, 0xF9, 0x7B, 0xB2, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB4, 0xF8, 0x7A, 0xB3, 0xF8, 0x7C, 0xB2, 0xF8, 0x7D, 0xB2, 0xF8, 0x7B, 0xB3, 0xF7, 0x7B, 0xB2, 0xF8, 0x7B, 0xB2, 0xF8, 0x79, 0xB4, 0xF8, 0x79, 0xB5, 0xF9, 0x7A, 0xB4, 0xF8, 0x7A, 0xB3, 0xF9, 0x7A, 0xB4, 0xFA, 0x7B, 0xB2, 0xF9, 0x7B, 0xB1, 0xF7, 0x7B, 0xB1, 0xF7, 0x7B, 0xB3, 0xF8, 0x7A, 0xB2, 0xF8, 0x7A, 0xB3, 0xF8, 0x79, 0xB2, 0xF9, 0x7A, 0xB3, 0xFA, 0x7B, 0xB3, 0xFA, 0x7B, 0xB1, 0xF8, 0x7D, 0xB2, 0xF9, 0x7E, 0xB2, 0xF9, 0x7C, 0xB3, 0xF8, 0x79, 0xB3, 0xF8, 0x79, 0xB4, 0xF8, 0x7A, 0xB3, 0xF8, 0x7B, 0xB2, 0xF8, 0x7B, 0xB2, 0xF8, 0x79, 0xB2, 0xF7, 0x7B, 0xB3, 0xF8, 0x7D, 0xB2, 0xF8, 0x7F, 0xB3, 0xF9, 0x7D, 0xB2, 0xF8, 0x7D, 0xB2, 0xF8, 0x7D, 0xB3, 0xF9, 0x7B, 0xB4, 0xF7, 0x7A, 0xB3, 0xF8, 0x79, 0xB4, 0xF8, 0x79, 0xB5, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7C, 0xB2, 0xF9, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7B, 0xB3, 0xF8, 0x7B, 0xB2, 0xF7, 0x7B, 0xB1, 0xF7, 0x7A, 0xB4, 0xF8, 0x79, 0xB5, 0xF8, 0x7A, 0xB2, 0xF9, 0x7B, 0xB1, 0xF7, 0x7C, 0xB2, 0xF8, 0x79, 0xB2, 0xF7, 0x78, 0xB4, 0xF8, 0x79, 0xB5, 0xF8, 0x7C, 0xB2, 0xF8, 0x7C, 0xB0, 0xF9, 0x7C, 0xB2, 0xFA, 0x7A, 0xB3, 0xF8, 0x7C, 0xB2, 0xF8, 0x7A, 0xB4, 0xF8, 0x79, 0xB4, 0xF9, 0x79, 0xB3, 0xF8, 0x79, 0xB2, 0xF7, 0x7B, 0xB1, 0xF7, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7B, 0xB1, 0xF7, 0x7A, 0xB1, 0xF8, 0x78, 0xB4, 0xF9, 0x78, 0xB5, 0xF8, 0x79, 0xB3, 0xF7, 0x79, 0xB3, 0xF9, 0x79, 0xB2, 0xFA, 0x7B, 0xB1, 0xF8, 0x7D, 0xB2, 0xF8, 0x7B, 0xB2, 0xF7, 0x79, 0xB2, 0xF7, 0x7B, 0xB2, 0xF9, 0x7B, 0xB2, 0xF9, 0x79, 0xB2, 0xF9, 0x7A, 0xB3, 0xFA, 0x7C, 0xB2, 0xF9, 0x7C, 0xB2, 0xF7, 0x7E, 0xB1, 0xF6, 0x7E, 0xB2, 0xF9, 0x7C, 0xB2, 0xF9, 0x7B, 0xB2, 0xF8, 0x7B, 0xB2, 0xF8, 0x7D, 0xB3, 0xF8, 0x7D, 0xB2, 0xF8, 0x7D, 0xB2, 0xF8, 0x7B, 0xB2, 0xF7, 0x79, 0xB2, 0xF7, 0x7C, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x7E, 0xB2, 0xF8, 0x80, 0xB2, 0xF9, 0x7D, 0xB2, 0xF7, 0x7C, 0xB3, 0xF6, 0x7A, 0xB3, 0xF6, 0x78, 0xB3, 0xF7, 0x79, 0xB4, 0xF8, 0x7A, 0xB3, 0xF9, 0x7A, 0xB3, 0xFA, 0x7A, 0xB3, 0xFA, 0x7B, 0xB1, 0xF9, 0x7C, 0xB2, 0xF9, 0x7C, 0xB3, 0xF8, 0x7B, 0xB2, 0xF7, 0x7C, 0xB2, 0xF8, 0x7B, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB2, 0xF9, 0x7C, 0xB2, 0xF9, 0x7C, 0xB2, 0xF7, 0x7B, 0xB3, 0xF8, 0x78, 0xB5, 0xF8, 0x79, 0xB5, 0xF8, 0x7B, 0xB3, 0xF8, 0x7E, 0xB0, 0xFA, 0x7D, 0xB1, 0xFA, 0x7B, 0xB3, 0xF9, 0x79, 0xB3, 0xF8, 0x79, 0xB3, 0xF9, 0x79, 0xB4, 0xFA, 0x7A, 0xB4, 0xFA, 0x79, 0xB3, 0xF9, 0x7B, 0xB2, 0xFA, 0x7C, 0xB2, 0xFA, 0x7D, 0xB2, 0xF9, 0x7B, 0xB2, 0xF8, 0x79, 0xB2, 0xF9, 0x77, 0xB4, 0xFA, 0x78, 0xB4, 0xF7, 0x7A, 0xB3, 0xF6, 0x7A, 0xB3, 0xFA, 0x7A, 0xB2, 0xFA, 0x7B, 0xB2, 0xFA, 0x7C, 0xB3, 0xF9, 0x7B, 0xB3, 0xF9, 0x79, 0xB2, 0xF7, 0x7C, 0xB1, 0xFA, 0x7C, 0xB1, 0xFA, 0x7B, 0xB1, 0xF9, 0x7A, 0xB1, 0xF8, 0x7C, 0xB1, 0xF7, 0x7D, 0xB2, 0xF6, 0x7E, 0xB1, 0xF8, 0x7C, 0xB2, 0xF9, 0x7B, 0xB2, 0xF7, 0x7D, 0xB3, 0xF8, 0x7E, 0xB2, 0xF8, 0x80, 0xB2, 0xFA, 0x7F, 0xB3, 0xF9, 0x7E, 0xB4, 0xF9, 0x7A, 0xB2, 0xF8, 0x7A, 0xB3, 0xF7, 0x7A, 0xB3, 0xF7, 0x7C, 0xB2, 0xF7, 0x7D, 0xB2, 0xF8, 0x7F, 0xB2, 0xF9, 0x7F, 0xB3, 0xF8, 0x7E, 0xB3, 0xF7, 0x7A, 0xB3, 0xF6, 0x79, 0xB3, 0xF8, 0x79, 0xB4, 0xF9, 0x7A, 0xB3, 0xFA, 0x7B, 0xB3, 0xFA, 0x7B, 0xB3, 0xFA, 0x7C, 0xB2, 0xFA, 0x7C, 0xB3, 0xFA, 0x7B, 0xB2, 0xF9, 0x7B, 0xB2, 0xF8, 0x7E, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7A, 0xB2, 0xF9, 0x7D, 0xB2, 0xFA, 0x7C, 0xB2, 0xF7, 0x7A, 0xB2, 0xF6, 0x79, 0xB3, 0xF8, 0x7C, 0xB3, 0xF9, 0x7D, 0xB2, 0xF9, 0x7D, 0xB2, 0xFA, 0x7D, 0xB2, 0xFB, 0x7B, 0xB1, 0xF8, 0x79, 0xB4, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xF9, 0x7C, 0xB2, 0xFA, 0x7D, 0xB1, 0xFA, 0x7D, 0xB2, 0xFB, 0x7A, 0xB2, 0xFA, 0x77, 0xB3, 0xFA, 0x78, 0xB3, 0xFA, 0x7B, 0xB2, 0xF9, 0x7E, 0xB1, 0xF8, 0x7D, 0xB2, 0xFA, 0x7C, 0xB1, 0xFB, 0x7C, 0xB2, 0xFB, 0x79, 0xB4, 0xFA, 0x78, 0xB4, 0xF9, 0x79, 0xB2, 0xF6, 0x7A, 0xB2, 0xF8, 0x7C, 0xB2, 0xF9, 0x7C, 0xB2, 0xF8, 0x7B, 0xB1, 0xF6, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF7, 0x7A, 0xB3, 0xFB, 0x79, 0xB3, 0xFA, 0x7A, 0xB3, 0xF4, 0x7E, 0xB3, 0xF6, 0x7F, 0xB2, 0xF9, 0x7E, 0xB2, 0xFB, 0x7F, 0xB3, 0xF7, 0x7D, 0xB3, 0xF7, 0x77, 0xB3, 0xF8, 0x79, 0xB3, 0xF8, 0x7D, 0xB3, 0xF8, 0x7E, 0xB3, 0xFA, 0x7D, 0xB4, 0xFA, 0x7C, 0xB2, 0xF8, 0x7F, 0xB3, 0xFA, 0x7F, 0xB3, 0xF9, 0x7C, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x79, 0xB5, 0xF8, 0x79, 0xB4, 0xFA, 0x7C, 0xB4, 0xFD, 0x7E, 0xB3, 0xFA, 0x7D, 0xB3, 0xF7, 0x7C, 0xB4, 0xF9, 0x7C, 0xB3, 0xFA, 0x7D, 0xB3, 0xF9, 0x7D, 0xB2, 0xF8, 0x7E, 0xB3, 0xF9, 0x7E, 0xB2, 0xF8, 0x7A, 0xB2, 0xFA, 0x7C, 0xB1, 0xFA, 0x7C, 0xB2, 0xF8, 0x7A, 0xB3, 0xF6, 0x79, 0xB3, 0xF9, 0x7A, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7D, 0xB1, 0xF9, 0x7C, 0xB1, 0xFA, 0x7C, 0xB2, 0xF8, 0x7A, 0xB4, 0xF8, 0x79, 0xB4, 0xF9, 0x79, 0xB4, 0xF9, 0x78, 0xB4, 0xF9, 0x79, 0xB3, 0xF8, 0x7B, 0xB2, 0xF8, 0x7D, 0xB1, 0xF8, 0x7A, 0xB2, 0xF9, 0x79, 0xB2, 0xFA, 0x7D, 0xB1, 0xFA, 0x7E, 0xB1, 0xFB, 0x7C, 0xB2, 0xF9, 0x7C, 0xB3, 0xF9, 0x7A, 0xB3, 0xF8, 0x7C, 0xB2, 0xF7, 0x7D, 0xB1, 0xFA, 0x7D, 0xB2, 0xFA, 0x7B, 0xB4, 0xF8, 0x7B, 0xB3, 0xF5, 0x7C, 0xB3, 0xF2, 0x7D, 0xB3, 0xF2, 0x7D, 0xB2, 0xF4, 0x7D, 0xB2, 0xF7, 0x7B, 0xB2, 0xF8, 0x78, 0xB3, 0xF9, 0x76, 0xB5, 0xF7, 0x7A, 0xB4, 0xF7, 0x7F, 0xB1, 0xF8, 0x7D, 0xB3, 0xFB, 0x79, 0xB4, 0xF9, 0x7C, 0xB4, 0xF6, 0x80, 0xB3, 0xF7, 0x7D, 0xB4, 0xF8, 0x7A, 0xB4, 0xF9, 0x7C, 0xB4, 0xFA, 0x7F, 0xB3, 0xFA, 0x7F, 0xB3, 0xFA, 0x7D, 0xB4, 0xF9, 0x7C, 0xB3, 0xF8, 0x7D, 0xB3, 0xF9, 0x7E, 0xB2, 0xF9, 0x7D, 0xB3, 0xF9, 0x7B, 0xB4, 0xF9, 0x7A, 0xB4, 0xF8, 0x7A, 0xB3, 0xFA, 0x7D, 0xB3, 0xFC, 0x7C, 0xB2, 0xF9, 0x7D, 0xB4, 0xF8, 0x7B, 0xB4, 0xF9, 0x7A, 0xB4, 0xF9, 0x7D, 0xB4, 0xF9, 0x7D, 0xB2, 0xF8, 0x7E, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7A, 0xB3, 0xFA, 0x79, 0xB2, 0xFA, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xF6, 0x7A, 0xB2, 0xF8, 0x7B, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7D, 0xB2, 0xF9, 0x7C, 0xB3, 0xF9, 0x79, 0xB2, 0xF7, 0x78, 0xB3, 0xF9, 0x78, 0xB4, 0xFA, 0x77, 0xB3, 0xF8, 0x79, 0xB2, 0xF7, 0x7C, 0xB2, 0xF8, 0x7C, 0xB1, 0xF8, 0x7B, 0xB3, 0xF5, 0x7C, 0xB3, 0xF4, 0x7D, 0xB2, 0xF4, 0x7F, 0xB3, 0xF6, 0x80, 0xB2, 0xF4, 0x7F, 0xB1, 0xF3, 0x7E, 0xB2, 0xF2, 0x7D, 0xB2, 0xF3, 0x7A, 0xB2, 0xF8, 0x78, 0xB3, 0xFA, 0x7B, 0xB3, 0xF8, 0x81, 0xB1, 0xF4, 0x86, 0xAE, 0xEC, 0x89, 0xAF, 0xE7, 0x89, 0xAE, 0xE4, 0x87, 0xB1, 0xE4, 0x82, 0xB4, 0xED, 0x79, 0xB3, 0xF3, 0x76, 0xB5, 0xF6, 0x79, 0xB5, 0xF8, 0x7E, 0xB2, 0xF8, 0x81, 0xB2, 0xF6, 0x81, 0xB1, 0xF3, 0x82, 0xB3, 0xF6, 0x82, 0xB4, 0xF7, 0x81, 0xB4, 0xF5, 0x80, 0xB5, 0xF6, 0x7E, 0xB5, 0xF8, 0x7D, 0xB5, 0xF8, 0x7D, 0xB5, 0xF5, 0x7C, 0xB4, 0xF8, 0x7C, 0xB4, 0xFB, 0x7D, 0xB3, 0xFB, 0x7D, 0xB3, 0xFB, 0x7D, 0xB3, 0xFB, 0x7D, 0xB4, 0xFB, 0x7B, 0xB4, 0xFA, 0x7A, 0xB3, 0xFA, 0x7C, 0xB2, 0xFC, 0x7D, 0xB2, 0xF9, 0x7B, 0xB4, 0xF7, 0x7A, 0xB5, 0xF9, 0x7A, 0xB5, 0xFA, 0x7B, 0xB4, 0xF9, 0x7D, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7F, 0xB4, 0xFA, 0x7B, 0xB3, 0xFA, 0x79, 0xB3, 0xFA, 0x7A, 0xB4, 0xF8, 0x7B, 0xB4, 0xF7, 0x7C, 0xB2, 0xF8, 0x7B, 0xB2, 0xF9, 0x7B, 0xB2, 0xF8, 0x7B, 0xB1, 0xF7, 0x7D, 0xB2, 0xF8, 0x7C, 0xB3, 0xF9, 0x79, 0xB2, 0xF8, 0x79, 0xB4, 0xF9, 0x79, 0xB4, 0xFA, 0x79, 0xB4, 0xF9, 0x7B, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF9, 0x7F, 0xB3, 0xF9, 0x7D, 0xB3, 0xF8, 0x7D, 0xB4, 0xF7, 0x80, 0xB2, 0xF4, 0x87, 0xB0, 0xED, 0x8F, 0xAD, 0xE8, 0x8E, 0xB2, 0xE7, 0x85, 0xB1, 0xE8, 0x80, 0xB5, 0xF1, 0x7D, 0xB6, 0xF4, 0x83, 0xB4, 0xF0, 0x8F, 0xAF, 0xEB, 0xA6, 0xB6, 0xE3, 0xAA, 0xB7, 0xD5, 0x98, 0xAA, 0xC1, 0x84, 0x9D, 0xB6, 0x78, 0x9A, 0xC3, 0x83, 0xAC, 0xEB, 0x7F, 0xB0, 0xF2, 0x7E, 0xB5, 0xF2, 0x81, 0xB4, 0xEA, 0x8D, 0xAF, 0xE1, 0x97, 0xAD, 0xE2, 0x90, 0xAF, 0xE9, 0x8E, 0xB0, 0xEF, 0x8D, 0xB0, 0xEE, 0x8B, 0xB3, 0xF0, 0x84, 0xB3, 0xF7, 0x7D, 0xB4, 0xFB, 0x79, 0xB4, 0xF8, 0x7B, 0xB4, 0xF8, 0x7D, 0xB3, 0xFA, 0x7D, 0xB3, 0xFA, 0x7D, 0xB3, 0xFA, 0x7C, 0xB3, 0xFA, 0x7B, 0xB3, 0xFA, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xFA, 0x7C, 0xB2, 0xFB, 0x7D, 0xB3, 0xF9, 0x7C, 0xB3, 0xF7, 0x7A, 0xB2, 0xF8, 0x79, 0xB3, 0xF9, 0x7C, 0xB3, 0xF8, 0x7C, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x79, 0xB3, 0xF9, 0x7B, 0xB4, 0xF7, 0x7C, 0xB3, 0xF6, 0x7E, 0xB2, 0xF8, 0x7C, 0xB4, 0xFB, 0x7B, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7C, 0xB3, 0xF9, 0x7B, 0xB3, 0xF9, 0x79, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7C, 0xB3, 0xF8, 0x7C, 0xB2, 0xF8, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB2, 0xFA, 0x7E, 0xB1, 0xFB, 0x83, 0xB3, 0xF9, 0x8B, 0xAE, 0xEB, 0x9A, 0xB2, 0xDD, 0xB4, 0xC2, 0xDC, 0xA4, 0xBA, 0xD1, 0x77, 0x94, 0xB2, 0x6C, 0x8C, 0xB4, 0x75, 0x98, 0xC4, 0x88, 0xA2, 0xCB, 0x9E, 0xAB, 0xD0, 0xB9, 0xBC, 0xCB, 0xA7, 0xAC, 0xAA, 0x9A, 0xA4, 0x9F, 0x84, 0x90, 0x94, 0x68, 0x7A, 0x90, 0x8E, 0xA2, 0xCE, 0x93, 0xB0, 0xDC, 0x7C, 0xA0, 0xC6, 0x7A, 0x98, 0xB9, 0xA2, 0xAE, 0xC7, 0xB9, 0xBB, 0xD0, 0xAD, 0xB8, 0xD0, 0xA7, 0xB1, 0xD4, 0xAB, 0xB3, 0xD9, 0xA1, 0xB1, 0xDC, 0x93, 0xB3, 0xEC, 0x84, 0xB4, 0xF9, 0x7D, 0xB4, 0xFB, 0x7F, 0xB4, 0xFB, 0x7F, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7B, 0xB5, 0xF9, 0x7A, 0xB4, 0xF8, 0x7B, 0xB4, 0xF9, 0x7A, 0xB3, 0xFA, 0x7C, 0xB2, 0xFC, 0x7C, 0xB2, 0xF8, 0x7D, 0xB4, 0xF7, 0x7C, 0xB3, 0xF9, 0x7C, 0xB3, 0xFA, 0x7D, 0xB4, 0xF9, 0x7C, 0xB2, 0xF8, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7C, 0xB3, 0xF8, 0x79, 0xB3, 0xF8, 0x7A, 0xB4, 0xF8, 0x7C, 0xB4, 0xF6, 0x7F, 0xB2, 0xF7, 0x7C, 0xB3, 0xFA, 0x7B, 0xB3, 0xFA, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7C, 0xB2, 0xF9, 0x7B, 0xB3, 0xFA, 0x7B, 0xB3, 0xF8, 0x7D, 0xB2, 0xF7, 0x7E, 0xB2, 0xF8, 0x7C, 0xB2, 0xF9, 0x7D, 0xB3, 0xF8, 0x7B, 0xB4, 0xF9, 0x7B, 0xB3, 0xF7, 0x80, 0xB2, 0xF7, 0x8D, 0xAF, 0xEE, 0xA2, 0xB3, 0xDD, 0xC1, 0xCC, 0xDB, 0xC5, 0xD0, 0xC5, 0x90, 0x9E, 0x9A, 0x67, 0x79, 0x83, 0x63, 0x73, 0x86, 0x6B, 0x79, 0x91, 0x84, 0x8C, 0xA1, 0xA9, 0xAA, 0xB7, 0xBD, 0xBC, 0xBB, 0xA5, 0xAA, 0x9E, 0x9A, 0xA3, 0x96, 0x7C, 0x89, 0x83, 0x6E, 0x79, 0x7D, 0x9E, 0xA9, 0xB7, 0xA7, 0xBA, 0xC7, 0x87, 0x99, 0xA9, 0x83, 0x8A, 0x9C, 0xAB, 0xAB, 0xB2, 0xD0, 0xCD, 0xCA, 0xBF, 0xC0, 0xB9, 0xDB, 0xD8, 0xD9, 0xED, 0xE7, 0xEE, 0xD1, 0xD2, 0xE1, 0xA7, 0xB6, 0xDB, 0x90, 0xB2, 0xEE, 0x84, 0xB4, 0xF6, 0x83, 0xB4, 0xF7, 0x83, 0xB3, 0xFA, 0x7F, 0xB4, 0xFB, 0x7C, 0xB4, 0xFA, 0x7C, 0xB4, 0xFA, 0x7C, 0xB4, 0xF9, 0x7B, 0xB5, 0xFA, 0x7B, 0xB4, 0xFB, 0x7D, 0xB2, 0xFB, 0x7D, 0xB2, 0xF9, 0x7D, 0xB3, 0xF7, 0x7F, 0xB3, 0xFA, 0x7F, 0xB3, 0xFB, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x7A, 0xB3, 0xF8, 0x79, 0xB4, 0xF8, 0x7B, 0xB4, 0xF9, 0x7E, 0xB4, 0xF8, 0x7A, 0xB3, 0xF7, 0x79, 0xB3, 0xF8, 0x7B, 0xB3, 0xF8, 0x7D, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7D, 0xB2, 0xF8, 0x7C, 0xB3, 0xF8, 0x80, 0xB1, 0xF6, 0x7E, 0xB1, 0xFB, 0x79, 0xB4, 0xFB, 0x7D, 0xB4, 0xF4, 0x7D, 0xB3, 0xF7, 0x80, 0xB3, 0xF7, 0x88, 0xAF, 0xF4, 0xA2, 0xB0, 0xD5, 0xCB, 0xCA, 0xCC, 0xD0, 0xDA, 0xCD, 0x95, 0xAA, 0x9E, 0x77, 0x84, 0x89, 0x76, 0x81, 0x8A, 0x7D, 0x85, 0x8F, 0x51, 0x57, 0x61, 0x53, 0x50, 0x5A, 0xA7, 0xA5, 0xA9, 0xC1, 0xBE, 0xB9, 0xB0, 0xB2, 0xA1, 0x96, 0xA4, 0x8F, 0x5E, 0x71, 0x6D, 0x34, 0x3F, 0x3F, 0x5D, 0x69, 0x6F, 0x62, 0x77, 0x74, 0x61, 0x6C, 0x73, 0x8D, 0x8F, 0x99, 0xA3, 0xA9, 0xA9, 0xCB, 0xCA, 0xC9, 0xC4, 0xC5, 0xB7, 0xE2, 0xE3, 0xD6, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD8, 0xD6, 0xE6, 0xAE, 0xB5, 0xE8, 0x8D, 0xB0, 0xF2, 0x84, 0xB6, 0xF6, 0x86, 0xB2, 0xF6, 0x80, 0xB3, 0xFA, 0x7C, 0xB5, 0xFC, 0x7E, 0xB3, 0xFB, 0x7E, 0xB4, 0xFA, 0x7A, 0xB4, 0xFA, 0x7C, 0xB4, 0xFB, 0x7E, 0xB3, 0xF9, 0x7F, 0xB3, 0xF9, 0x7D, 0xB2, 0xF8, 0x7F, 0xB2, 0xF9, 0x7E, 0xB2, 0xF8, 0x7E, 0xB3, 0xF9, 0x7E, 0xB2, 0xF8, 0x7D, 0xB3, 0xF9, 0x7B, 0xB3, 0xF8, 0x7E, 0xB3, 0xF9, 0x7B, 0xB3, 0xF8, 0x79, 0xB4, 0xF8, 0x7A, 0xB3, 0xF8, 0x7B, 0xB3, 0xF7, 0x7A, 0xB3, 0xF7, 0x7A, 0xB3, 0xF8, 0x7B, 0xB4, 0xF9, 0x7C, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x81, 0xB2, 0xF3, 0x7F, 0xB3, 0xF8, 0x7A, 0xB3, 0xFD, 0x7B, 0xB3, 0xF8, 0x7F, 0xB2, 0xF5, 0x82, 0xB1, 0xF7, 0x8A, 0xB0, 0xF2, 0xA0, 0xB3, 0xDE, 0xC8, 0xCB, 0xC9, 0xD5, 0xDB, 0xC4, 0xA4, 0xB4, 0xA2, 0x79, 0x8C, 0x95, 0x61, 0x71, 0x8B, 0x4E, 0x56, 0x6C, 0x80, 0x7F, 0x8E, 0x57, 0x58, 0x62, 0x3A, 0x2C, 0x38, 0xA9, 0xA2, 0xAB, 0xC1, 0xC1, 0xBC, 0xB0, 0xB6, 0xA1, 0x8B, 0x99, 0x82, 0x3C, 0x4C, 0x49, 0x1B, 0x23, 0x22, 0x1F, 0x27, 0x2D, 0x1E, 0x26, 0x2B, 0x21, 0x1F, 0x33, 0x39, 0x38, 0x50, 0x8E, 0x92, 0x9C, 0xBE, 0xBD, 0xC0, 0xCB, 0xC9, 0xC5, 0xC3, 0xC5, 0xB9, 0xE4, 0xE6, 0xDD, 0xFF, 0xFF, 0xFF, 0xF6, 0xF5, 0xF8, 0xCA, 0xCE, 0xE0, 0xA1, 0xB1, 0xDF, 0x8D, 0xB4, 0xF5, 0x83, 0xB6, 0xF7, 0x82, 0xB4, 0xF4, 0x80, 0xB2, 0xF6, 0x7D, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7D, 0xB2, 0xFA, 0x7E, 0xB4, 0xFB, 0x7E, 0xB4, 0xFA, 0x7E, 0xB3, 0xF9, 0x7D, 0xB2, 0xF8, 0x7D, 0xB3, 0xF9, 0x7D, 0xB2, 0xF8, 0x7F, 0xB4, 0xFA, 0x7E, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7C, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7B, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB3, 0xF8, 0x7A, 0xB4, 0xF8, 0x7B, 0xB4, 0xF9, 0x7A, 0xB4, 0xF9, 0x7B, 0xB3, 0xF8, 0x7D, 0xB2, 0xF8, 0x7C, 0xB2, 0xF8, 0x7E, 0xB3, 0xF5, 0x7A, 0xB4, 0xF8, 0x7D, 0xB3, 0xFA, 0x7F, 0xB2, 0xF9, 0x7F, 0xB2, 0xFB, 0x8A, 0xAF, 0xF0, 0xA2, 0xAF, 0xDB, 0xCE, 0xCE, 0xD5, 0xDE, 0xE5, 0xCC, 0xA8, 0xBC, 0xA6, 0x7F, 0x92, 0x92, 0x77, 0x87, 0xA5, 0x5F, 0x74, 0xA1, 0x4F, 0x5F, 0x81, 0x52, 0x63, 0x70, 0x4C, 0x59, 0x5B, 0x47, 0x34, 0x3E, 0xBD, 0xB3, 0xB8, 0xB6, 0xBB, 0xB2, 0xA5, 0xAD, 0x99, 0x8E, 0x9B, 0x8D, 0x2C, 0x37, 0x3E, 0x1F, 0x21, 0x24, 0x23, 0x24, 0x2C, 0x2A, 0x2B, 0x38, 0x40, 0x3F, 0x64, 0x3E, 0x43, 0x76, 0x5C, 0x67, 0x88, 0xA4, 0xA9, 0xB8, 0xC8, 0xC6, 0xCB, 0xC6, 0xC8, 0xBD, 0xB5, 0xB9, 0xAA, 0xC9, 0xCA, 0xC4, 0xFC, 0xFB, 0xFB, 0xF8, 0xF9, 0xF8, 0xCB, 0xCB, 0xDD, 0xA2, 0xB0, 0xE1, 0x88, 0xB4, 0xF0, 0x81, 0xB6, 0xF8, 0x82, 0xB4, 0xFA, 0x7E, 0xB4, 0xF6, 0x7C, 0xB4, 0xF8, 0x7E, 0xB2, 0xF9, 0x7F, 0xB4, 0xFA, 0x7F, 0xB5, 0xFB, 0x7D, 0xB3, 0xF9, 0x7C, 0xB3, 0xF9, 0x7B, 0xB4, 0xF8, 0x7C, 0xB3, 0xF8, 0x7E, 0xB3, 0xF9, 0x7E, 0xB3, 0xF7, 0x7E, 0xB3, 0xF8, 0x7D, 0xB3, 0xF9, 0x7B, 0xB3, 0xF8, 0x7B, 0xB4, 0xF9, 0x7B, 0xB4, 0xF9, 0x7A, 0xB3, 0xF8, 0x7C, 0xB4, 0xF9, 0x7B, 0xB2, 0xF8, 0x7B, 0xB3, 0xF8, 0x7B, 0xB3, 0xF8, 0x7B, 0xB3, 0xF8, 0x7C, 0xB2, 0xF8, 0x7C, 0xB3, 0xF8, 0x7E, 0xB2, 0xFB, 0x7B, 0xB3, 0xF8, 0x7B, 0xB4, 0xF4, 0x7C, 0xB3, 0xF8, 0x85, 0xB2, 0xF4, 0x9E, 0xAD, 0xD9, 0xCA, 0xCA, 0xD9, 0xE4, 0xE8, 0xD9, 0xB5, 0xC3, 0xAB, 0x7E, 0x91, 0x91, 0x77, 0x86, 0xA6, 0x81, 0x99, 0xCA, 0x8A, 0xA6, 0xD8, 0x68, 0x7E, 0xA1, 0x3F, 0x52, 0x5F, 0x28, 0x29, 0x2E, 0x5B, 0x3B, 0x47, 0xC7, 0xBE, 0xBC, 0xAD, 0xB4, 0xA7, 0x9C, 0xA4, 0x95, 0x84, 0x8F, 0x8F, 0x2B, 0x34, 0x4B, 0x20, 0x20, 0x2A, 0x25, 0x21, 0x29, 0x25, 0x27, 0x38, 0x70, 0x7D, 0xAB, 0x8D, 0xA5, 0xEB, 0x6F, 0x88, 0xC6, 0x89, 0x9B, 0xBF, 0xB9, 0xBF, 0xCB, 0xC8, 0xCC, 0xC6, 0xBE, 0xC2, 0xB5, 0xA0, 0xA1, 0x99, 0xCC, 0xCD, 0xD0, 0xFF, 0xFF, 0xFF, 0xF9, 0xF7, 0xF8, 0xCC, 0xC7, 0xDC, 0x9D, 0xB1, 0xE0, 0x85, 0xB5, 0xFA, 0x81, 0xB3, 0xFD, 0x80, 0xB4, 0xF7, 0x7C, 0xB5, 0xF7, 0x7E, 0xB4, 0xF8, 0x7F, 0xB4, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7C, 0xB4, 0xF8, 0x7A, 0xB4, 0xF6, 0x7C, 0xB5, 0xF8, 0x7F, 0xB4, 0xF9, 0x7E, 0xB3, 0xF7, 0x7E, 0xB4, 0xF7, 0x7D, 0xB3, 0xF9, 0x79, 0xB4, 0xF8, 0x7A, 0xB3, 0xF9, 0x7B, 0xB4, 0xFB, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7A, 0xB3, 0xF8, 0x7D, 0xB2, 0xFB, 0x7D, 0xB4, 0xF8, 0x7C, 0xB5, 0xF6, 0x87, 0xB2, 0xF1, 0x9D, 0xAE, 0xDA, 0xC8, 0xC6, 0xD5, 0xE5, 0xEA, 0xE5, 0xBD, 0xCA, 0xB8, 0x8D, 0x97, 0x93, 0x7D, 0x88, 0x9C, 0x82, 0x95, 0xC5, 0x8F, 0xAC, 0xE3, 0x95, 0xAF, 0xD5, 0x5B, 0x6B, 0x82, 0x22, 0x20, 0x2D, 0x2D, 0x1D, 0x29, 0x7D, 0x61, 0x6F, 0xC9, 0xC4, 0xC1, 0xB1, 0xB5, 0xA7, 0x9C, 0xA1, 0x96, 0x88, 0x93, 0xA0, 0x55, 0x60, 0x84, 0x1C, 0x1C, 0x2A, 0x25, 0x1E, 0x22, 0x1E, 0x1B, 0x2F, 0x5D, 0x71, 0x9C, 0x92, 0xB9, 0xFB, 0x8C, 0xB2, 0xF7, 0x8F, 0xAD, 0xE0, 0xA6, 0xB5, 0xCB, 0xC4, 0xCB, 0xCE, 0xCA, 0xCC, 0xC9, 0xB4, 0xB3, 0xAC, 0x9C, 0xA4, 0xA0, 0xD4, 0xE0, 0xE3, 0xFF, 0xFF, 0xFF, 0xF7, 0xF3, 0xF7, 0xC1, 0xC4, 0xDE, 0x98, 0xB4, 0xE8, 0x84, 0xB2, 0xF7, 0x81, 0xB3, 0xFA, 0x7E, 0xB5, 0xF6, 0x7E, 0xB5, 0xF7, 0x80, 0xB4, 0xF9, 0x7F, 0xB4, 0xFA, 0x7D, 0xB2, 0xF8, 0x7D, 0xB3, 0xF7, 0x7C, 0xB5, 0xF5, 0x7C, 0xB5, 0xF7, 0x7D, 0xB5, 0xF8, 0x7D, 0xB4, 0xF7, 0x7E, 0xB5, 0xF7, 0x7E, 0xB4, 0xF9, 0x7A, 0xB5, 0xF9, 0x79, 0xB3, 0xF8, 0x7B, 0xB2, 0xF9, 0x7C, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7D, 0xB3, 0xF8, 0x7D, 0xB2, 0xF9, 0x7E, 0xB3, 0xF9, 0x7D, 0xB4, 0xF9, 0x7C, 0xB3, 0xF8, 0x7C, 0xB5, 0xF7, 0x7C, 0xB6, 0xF7, 0x84, 0xB1, 0xF5, 0x9D, 0xAA, 0xE2, 0xC6, 0xBF, 0xD2, 0xE9, 0xED, 0xE2, 0xC9, 0xD6, 0xC2, 0x97, 0xA5, 0x9A, 0x88, 0x93, 0xA2, 0x8B, 0x9B, 0xBD, 0x95, 0xB0, 0xE1, 0x9B, 0xB0, 0xDE, 0xA3, 0xB4, 0xCA, 0x68, 0x70, 0x7C, 0x5E, 0x54, 0x5F, 0x71, 0x65, 0x72, 0xB6, 0xAD, 0xB9, 0xC0, 0xBE, 0xBD, 0xB8, 0xB3, 0xAB, 0x9D, 0xA0, 0x97, 0x88, 0x95, 0xA8, 0x8A, 0x99, 0xC5, 0x59, 0x5B, 0x6B, 0x58, 0x53, 0x55, 0x4B, 0x46, 0x58, 0x6B, 0x7B, 0xA1, 0x90, 0xBB, 0xF1, 0x89, 0xB6, 0xF4, 0x91, 0xB4, 0xEC, 0x9E, 0xB2, 0xD3, 0xB7, 0xC0, 0xC8, 0xC9, 0xCA, 0xCE, 0xC0, 0xC1, 0xBC, 0xA0, 0xAA, 0x9C, 0x8F, 0xA0, 0xA1, 0xDC, 0xE8, 0xED, 0xFF, 0xFF, 0xFF, 0xEC, 0xEB, 0xF4, 0xB8, 0xBE, 0xDB, 0x93, 0xB3, 0xEB, 0x83, 0xB4, 0xFC, 0x80, 0xB5, 0xF7, 0x7F, 0xB5, 0xF4, 0x80, 0xB4, 0xF8, 0x7F, 0xB4, 0xFA, 0x7E, 0xB3, 0xF9, 0x7E, 0xB4, 0xF6, 0x7E, 0xB4, 0xF5, 0x7C, 0xB4, 0xF7, 0x7B, 0xB4, 0xF8, 0x7C, 0xB4, 0xF7, 0x7D, 0xB4, 0xF7, 0x7D, 0xB3, 0xF7, 0x7C, 0xB3, 0xF9, 0x7C, 0xB3, 0xF9, 0x7D, 0xB2, 0xF8, 0x7B, 0xB4, 0xF9, 0x7B, 0xB4, 0xF9, 0x7D, 0xB2, 0xF9, 0x7D, 0xB3, 0xF8, 0x81, 0xB0, 0xFA, 0x82, 0xB3, 0xF9, 0x7C, 0xB7, 0xF6, 0x7D, 0xB4, 0xF6, 0x7F, 0xB4, 0xF9, 0x83, 0xB3, 0xF3, 0x96, 0xAB, 0xDE, 0xBF, 0xBD, 0xD6, 0xE9, 0xED, 0xE7, 0xCF, 0xDD, 0xC5, 0x9B, 0xAA, 0x9B, 0x88, 0x97, 0xA7, 0x88, 0x9D, 0xBF, 0x94, 0xB1, 0xE1, 0x93, 0xAE, 0xDF, 0x9C, 0xAE, 0xD1, 0x9C, 0xAC, 0xB6, 0x92, 0x93, 0x9C, 0x93, 0x8D, 0x9A, 0xB2, 0xA5, 0xB8, 0xCF, 0xC8, 0xD1, 0xB7, 0xB3, 0xB4, 0xB5, 0xAC, 0xAC, 0xA3, 0x9F, 0x9D, 0x7C, 0x8D, 0xA3, 0x83, 0xA1, 0xD7, 0x74, 0x80, 0x99, 0x7D, 0x7B, 0x81, 0x7D, 0x7F, 0x89, 0x7F, 0x8B, 0xAC, 0x82, 0xA2, 0xD9, 0x74, 0xA3, 0xDC, 0x82, 0xAA, 0xE7, 0x92, 0xAE, 0xD7, 0xA7, 0xB7, 0xC8, 0xC1, 0xC6, 0xC9, 0xC4, 0xC9, 0xCB, 0xB6, 0xBB, 0xB1, 0x8C, 0x97, 0x99, 0x9B, 0xB0, 0xBE, 0xE2, 0xEF, 0xF4, 0xFF, 0xFF, 0xFF, 0xE6, 0xE0, 0xEB, 0xB2, 0xB7, 0xDC, 0x91, 0xB4, 0xEE, 0x83, 0xB5, 0xF7, 0x80, 0xB4, 0xF5, 0x7F, 0xB3, 0xF5, 0x7F, 0xB4, 0xF9, 0x7E, 0xB5, 0xF8, 0x7E, 0xB5, 0xF3, 0x7F, 0xB4, 0xF9, 0x7D, 0xB4, 0xFB, 0x7C, 0xB4, 0xF9, 0x7D, 0xB3, 0xF8, 0x7D, 0xB4, 0xF7, 0x7E, 0xB4, 0xFA, 0x7D, 0xB2, 0xF8, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7C, 0xB3, 0xF9, 0x7B, 0xB4, 0xF9, 0x7B, 0xB3, 0xF8, 0x7C, 0xB4, 0xF9, 0x81, 0xB3, 0xF8, 0x82, 0xB4, 0xF9, 0x7D, 0xB7, 0xFA, 0x7F, 0xB6, 0xF8, 0x84, 0xB2, 0xF8, 0x97, 0xAE, 0xE4, 0xB8, 0xB9, 0xD6, 0xE7, 0xE9, 0xEE, 0xD1, 0xDD, 0xCC, 0xA6, 0xB2, 0xA2, 0x8E, 0x9C, 0xA2, 0x81, 0x96, 0xBD, 0x7D, 0x9F, 0xD5, 0x83, 0xAE, 0xEA, 0x7F, 0xA3, 0xD9, 0x81, 0x9A, 0xBC, 0x4D, 0x5C, 0x67, 0x26, 0x26, 0x30, 0x2E, 0x2A, 0x3F, 0x88, 0x7D, 0x9E, 0xDE, 0xD9, 0xE4, 0xE5, 0xE3, 0xE2, 0xE4, 0xE1, 0xE1, 0xDA, 0xD5, 0xD5, 0x99, 0xAB, 0xC6, 0x80, 0xAC, 0xEC, 0x28, 0x3F, 0x66, 0x23, 0x22, 0x29, 0x23, 0x26, 0x27, 0x4D, 0x5A, 0x78, 0x8D, 0xB0, 0xEA, 0x7B, 0xAE, 0xEC, 0x79, 0xAB, 0xEC, 0x7D, 0xA7, 0xDF, 0x95, 0xAD, 0xD5, 0xAE, 0xAF, 0xBF, 0xB3, 0xB6, 0xBA, 0xBD, 0xC4, 0xC1, 0xA8, 0xB2, 0xB3, 0x7C, 0x94, 0xA1, 0xA3, 0xBC, 0xCA, 0xED, 0xF5, 0xF7, 0xFF, 0xFF, 0xFF, 0xDC, 0xDE, 0xEB, 0xAB, 0xB7, 0xE0, 0x8F, 0xB3, 0xF1, 0x81, 0xB5, 0xF8, 0x7F, 0xB5, 0xF8, 0x7E, 0xB5, 0xF7, 0x7F, 0xB4, 0xF6, 0x7F, 0xB4, 0xF7, 0x7F, 0xB4, 0xF9, 0x7D, 0xB5, 0xF9, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF8, 0x7E, 0xB4, 0xF7, 0x7E, 0xB4, 0xFA, 0x7E, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x7C, 0xB3, 0xF9, 0x7B, 0xB4, 0xF9, 0x7B, 0xB4, 0xF9, 0x7C, 0xB5, 0xF9, 0x81, 0xB3, 0xF7, 0x80, 0xB4, 0xF8, 0x7D, 0xB5, 0xFC, 0x83, 0xB4, 0xF4, 0x97, 0xAD, 0xE7, 0xB6, 0xB4, 0xD4, 0xEC, 0xE5, 0xEE, 0xC4, 0xCD, 0xC4, 0xAE, 0xBA, 0xA7, 0xA3, 0xAB, 0xA8, 0x8A, 0x98, 0xAF, 0x86, 0xA2, 0xDA, 0x86, 0xB3, 0xF7, 0x83, 0xB3, 0xF4, 0x82, 0xA3, 0xD6, 0x77, 0x8A, 0xA5, 0x37, 0x3B, 0x4E, 0x33, 0x2B, 0x40, 0x58, 0x52, 0x78, 0xB0, 0xA7, 0xD8, 0xED, 0xEC, 0xF5, 0xEA, 0xED, 0xE5, 0xDF, 0xE3, 0xDD, 0xF2, 0xF1, 0xF1, 0xA8, 0xBC, 0xDA, 0x86, 0xB1, 0xF0, 0x3B, 0x4C, 0x75, 0x2A, 0x28, 0x31, 0x2A, 0x2C, 0x2D, 0x40, 0x4A, 0x6A, 0x8D, 0xAE, 0xEC, 0x81, 0xB6, 0xF7, 0x7F, 0xB6, 0xF8, 0x82, 0xB4, 0xF7, 0x93, 0xB5, 0xEF, 0xAB, 0xAE, 0xC7, 0xA6, 0xA6, 0xAB, 0x7F, 0x85, 0x87, 0x7C, 0x80, 0x7F, 0x61, 0x73, 0x7B, 0x5E, 0x79, 0x93, 0x9C, 0xB2, 0xC3, 0xF1, 0xFA, 0xF9, 0xFF, 0xFF, 0xFD, 0xD5, 0xD2, 0xE5, 0x9E, 0xB4, 0xE3, 0x88, 0xB4, 0xF3, 0x7F, 0xB4, 0xF7, 0x80, 0xB6, 0xF7, 0x82, 0xB4, 0xF6, 0x80, 0xB4, 0xFC, 0x7D, 0xB4, 0xFA, 0x7E, 0xB4, 0xF7, 0x7E, 0xB4, 0xFA, 0x7E, 0xB4, 0xF9, 0x7E, 0xB4, 0xF7, 0x7E, 0xB4, 0xFA, 0x7E, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7C, 0xB3, 0xF8, 0x7B, 0xB4, 0xF9, 0x7B, 0xB4, 0xF9, 0x7B, 0xB4, 0xFA, 0x81, 0xB3, 0xF6, 0x80, 0xB4, 0xF7, 0x82, 0xB3, 0xFB, 0x90, 0xB1, 0xE9, 0xB1, 0xAE, 0xCF, 0xDA, 0xD1, 0xDD, 0xF3, 0xF6, 0xF5, 0xA9, 0xB5, 0xAB, 0xA9, 0xAD, 0xA1, 0x99, 0x9D, 0xA6, 0x83, 0x91, 0xAF, 0x8D, 0xAD, 0xE5, 0x85, 0xB2, 0xF2, 0x85, 0xAB, 0xE2, 0x88, 0x99, 0xBC, 0x5E, 0x62, 0x72, 0x30, 0x2B, 0x33, 0x41, 0x38, 0x45, 0x89, 0x89, 0xA9, 0xBA, 0xB7, 0xE1, 0xE3, 0xE6, 0xED, 0xCF, 0xD5, 0xCD, 0xD1, 0xD8, 0xCC, 0xDE, 0xE5, 0xE1, 0xA4, 0xBC, 0xD6, 0x98, 0xB7, 0xEB, 0x56, 0x5C, 0x7F, 0x2F, 0x2D, 0x3A, 0x2C, 0x2D, 0x36, 0x38, 0x40, 0x5E, 0x89, 0xA5, 0xDF, 0x85, 0xB4, 0xF4, 0x7F, 0xB4, 0xF0, 0x82, 0xB3, 0xF4, 0x8E, 0xB4, 0xF2, 0xB2, 0xB7, 0xD3, 0xBC, 0xBB, 0xBE, 0xA1, 0xA3, 0xA5, 0x8B, 0x8C, 0x86, 0x71, 0x7B, 0x78, 0x60, 0x71, 0x91, 0x7C, 0x9C, 0xBA, 0xA8, 0xC0, 0xCD, 0xFA, 0xFB, 0xFD, 0xF4, 0xF1, 0xF5, 0xB1, 0xBC, 0xD5, 0x9B, 0xB4, 0xE6, 0x85, 0xB4, 0xF3, 0x80, 0xB7, 0xF8, 0x83, 0xB5, 0xF6, 0x80, 0xB4, 0xFD, 0x7D, 0xB4, 0xFC, 0x7F, 0xB4, 0xF7, 0x7F, 0xB4, 0xFA, 0x7E, 0xB4, 0xF9, 0x7E, 0xB5, 0xF8, 0x7E, 0xB4, 0xFA, 0x7D, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7E, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7C, 0xB4, 0xF9, 0x7D, 0xB4, 0xF8, 0x7E, 0xB4, 0xFC, 0x81, 0xB5, 0xF7, 0x80, 0xB3, 0xF7, 0x88, 0xB1, 0xF7, 0xA7, 0xB3, 0xE0, 0xD7, 0xCF, 0xD7, 0xF8, 0xF8, 0xF9, 0xDE, 0xE7, 0xE8, 0xC1, 0xC6, 0xBB, 0xBC, 0xBF, 0xB2, 0x94, 0x98, 0xA4, 0x7F, 0x8D, 0xA6, 0x8B, 0xA7, 0xD8, 0x92, 0xB9, 0xEF, 0x9B, 0xB6, 0xDA, 0xAC, 0xAF, 0xC1, 0x96, 0x93, 0x99, 0x9C, 0x9E, 0x9D, 0xA7, 0xAA, 0xB3, 0xC1, 0xCD, 0xE4, 0xC8, 0xCF, 0xEB, 0xE3, 0xE8, 0xED, 0xC9, 0xCE, 0xC9, 0xD2, 0xD5, 0xCB, 0xCB, 0xD4, 0xD2, 0x91, 0xAA, 0xC2, 0x9B, 0xB9, 0xEC, 0x99, 0xAB, 0xCD, 0x98, 0x9D, 0xA9, 0x92, 0x94, 0x9B, 0x83, 0x8E, 0xA2, 0x91, 0xAD, 0xD7, 0x8A, 0xB5, 0xEB, 0x88, 0xB6, 0xEE, 0x8B, 0xB6, 0xEE, 0x92, 0xB3, 0xE9, 0xBD, 0xC5, 0xDF, 0xC9, 0xC7, 0xCA, 0xC0, 0xBF, 0xC1, 0xBA, 0xBE, 0xB8, 0x88, 0x91, 0x83, 0x4E, 0x58, 0x6E, 0x67, 0x80, 0xA3, 0x73, 0x90, 0xB2, 0xCB, 0xD8, 0xE6, 0xF8, 0xF8, 0xFA, 0xD0, 0xCB, 0xD6, 0xB3, 0xBA, 0xDA, 0x8E, 0xB4, 0xED, 0x80, 0xB6, 0xFA, 0x82, 0xB4, 0xF4, 0x7E, 0xB5, 0xF9, 0x7D, 0xB4, 0xFD, 0x80, 0xB3, 0xF8, 0x7E, 0xB3, 0xFA, 0x7E, 0xB4, 0xFA, 0x7C, 0xB5, 0xF8, 0x7C, 0xB4, 0xF8, 0x7C, 0xB3, 0xF9, 0x7C, 0xB2, 0xF8, 0x7D, 0xB3, 0xF9, 0x7F, 0xB5, 0xFB, 0x7D, 0xB4, 0xFA, 0x7F, 0xB3, 0xF8, 0x7F, 0xB4, 0xFB, 0x80, 0xB5, 0xF8, 0x80, 0xB5, 0xF8, 0x89, 0xAF, 0xF1, 0xC6, 0xC3, 0xE5, 0xF6, 0xF5, 0xF2, 0xED, 0xF8, 0xF8, 0xC8, 0xCD, 0xD2, 0xC8, 0xC7, 0xB8, 0xB2, 0xB9, 0xA5, 0x84, 0x8C, 0x98, 0x8B, 0x98, 0xB5, 0x8D, 0xA9, 0xD7, 0x89, 0xAB, 0xD8, 0x8A, 0x9F, 0xB8, 0x94, 0x99, 0xA0, 0x8C, 0x8F, 0x8F, 0x84, 0x8D, 0x97, 0x8F, 0x9C, 0xBC, 0x9F, 0xB7, 0xDB, 0xAC, 0xBA, 0xD7, 0xDF, 0xE3, 0xEB, 0xCD, 0xD0, 0xCD, 0xD4, 0xD3, 0xCC, 0xD5, 0xDF, 0xDC, 0x9B, 0xB5, 0xCD, 0x8E, 0xB3, 0xEC, 0x6A, 0x8E, 0xB8, 0x50, 0x5B, 0x67, 0x67, 0x6A, 0x6D, 0x65, 0x74, 0x7E, 0x7F, 0x9C, 0xB9, 0x83, 0xAC, 0xDC, 0x83, 0xAD, 0xE2, 0x85, 0xAA, 0xDF, 0x8C, 0xA7, 0xD9, 0xA4, 0xAC, 0xC7, 0xC7, 0xC7, 0xCB, 0xBA, 0xB8, 0xBD, 0xA7, 0xB4, 0xAD, 0x75, 0x84, 0x72, 0x3B, 0x44, 0x4C, 0x41, 0x52, 0x72, 0x78, 0x95, 0xBF, 0xA0, 0xBC, 0xD9, 0xE4, 0xE5, 0xEE, 0xF7, 0xEA, 0xEF, 0xD4, 0xD2, 0xE2, 0x91, 0xAF, 0xE2, 0x84, 0xB6, 0xFD, 0x83, 0xB6, 0xF6, 0x7E, 0xB6, 0xF8, 0x7D, 0xB5, 0xFB, 0x80, 0xB3, 0xFA, 0x7F, 0xB4, 0xFA, 0x7D, 0xB4, 0xF9, 0x7B, 0xB5, 0xF8, 0x7B, 0xB5, 0xF9, 0x7D, 0xB4, 0xFA, 0x7E, 0xB3, 0xFA, 0x7D, 0xB3, 0xF9, 0x7E, 0xB5, 0xFA, 0x7C, 0xB5, 0xF8, 0x7F, 0xB4, 0xF7, 0x7C, 0xB6, 0xF7, 0x7D, 0xB6, 0xF7, 0x7D, 0xB4, 0xFA, 0x8C, 0xB1, 0xED, 0xCB, 0xC4, 0xDD, 0xE7, 0xEC, 0xEC, 0xC1, 0xD5, 0xD8, 0xB7, 0xB5, 0xB8, 0xCE, 0xD1, 0xC2, 0xB0, 0xB7, 0xA8, 0x81, 0x89, 0x9C, 0x84, 0x9D, 0xCB, 0x8C, 0xAE, 0xE8, 0x8D, 0xA5, 0xCE, 0x79, 0x8D, 0x9F, 0x32, 0x3F, 0x42, 0x36, 0x38, 0x3B, 0x4D, 0x4E, 0x68, 0x67, 0x7B, 0xA4, 0x67, 0x85, 0xB4, 0x95, 0x9A, 0xBE, 0xE3, 0xE3, 0xE9, 0xCD, 0xCE, 0xCF, 0xCF, 0xD2, 0xCB, 0xD1, 0xDD, 0xD6, 0x8C, 0xA3, 0xC3, 0x7C, 0x9A, 0xD2, 0x5A, 0x76, 0xA8, 0x2B, 0x30, 0x3E, 0x45, 0x43, 0x46, 0x36, 0x3C, 0x49, 0x61, 0x73, 0x96, 0x76, 0x9C, 0xCF, 0x67, 0x96, 0xCE, 0x6B, 0x91, 0xC9, 0x6C, 0x86, 0xBE, 0x85, 0x8E, 0xB3, 0xC8, 0xC5, 0xCA, 0xB6, 0xB2, 0xB7, 0x9B, 0xAE, 0xA4, 0x76, 0x83, 0x76, 0x3A, 0x41, 0x43, 0x3E, 0x4C, 0x64, 0x5B, 0x77, 0x99, 0x91, 0xAE, 0xDA, 0xC2, 0xC3, 0xDC, 0xFB, 0xF5, 0xF6, 0xEA, 0xEE, 0xEE, 0x97, 0xAF, 0xDB, 0x85, 0xB7, 0xFA, 0x7F, 0xB7, 0xF9, 0x7D, 0xB5, 0xFA, 0x7B, 0xB4, 0xF8, 0x7F, 0xB3, 0xF8, 0x80, 0xB4, 0xF9, 0x7D, 0xB4, 0xF9, 0x7B, 0xB7, 0xFB, 0x7C, 0xB5, 0xFA, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7E, 0xB4, 0xFA, 0x7B, 0xB5, 0xF9, 0x7B, 0xB6, 0xF8, 0x7E, 0xB5, 0xF8, 0x7D, 0xB5, 0xF8, 0x7E, 0xB6, 0xF8, 0x7D, 0xB5, 0xFA, 0x8F, 0xB2, 0xEB, 0xCA, 0xC2, 0xD8, 0xF8, 0xFA, 0xFB, 0xAF, 0xC0, 0xC8, 0xAA, 0xA7, 0xAD, 0xD0, 0xD3, 0xC4, 0xAF, 0xB8, 0xA8, 0x88, 0x93, 0xA3, 0x8A, 0xA7, 0xDA, 0x8A, 0xAF, 0xE8, 0x8A, 0xA1, 0xC3, 0x65, 0x71, 0x7E, 0x29, 0x25, 0x2C, 0x35, 0x24, 0x34, 0x70, 0x6E, 0x92, 0xA1, 0xB0, 0xD3, 0x98, 0xAA, 0xC9, 0xB3, 0xB2, 0xC9, 0xE4, 0xE4, 0xE8, 0xCF, 0xCB, 0xCC, 0xCE, 0xCF, 0xCE, 0xCE, 0xDA, 0xDA, 0x93, 0xA6, 0xC9, 0x7C, 0x95, 0xCA, 0x5F, 0x77, 0xA4, 0x4B, 0x50, 0x5A, 0x78, 0x6E, 0x72, 0x5A, 0x54, 0x62, 0x58, 0x60, 0x85, 0x79, 0x98, 0xCD, 0x70, 0x9C, 0xD8, 0x77, 0x9D, 0xD8, 0x86, 0xA2, 0xDE, 0x99, 0xA3, 0xCC, 0xC6, 0xC3, 0xC9, 0xAE, 0xAA, 0xB1, 0x98, 0xAB, 0x9E, 0x6E, 0x7F, 0x6F, 0x2F, 0x31, 0x35, 0x31, 0x31, 0x48, 0x41, 0x51, 0x6F, 0x67, 0x7B, 0xA6, 0xAC, 0xAB, 0xC6, 0xEC, 0xE6, 0xE9, 0xDA, 0xDF, 0xE1, 0x8C, 0xA5, 0xCF, 0x84, 0xB6, 0xF9, 0x7E, 0xB5, 0xF7, 0x7C, 0xB5, 0xF7, 0x7C, 0xB6, 0xF8, 0x7F, 0xB4, 0xF9, 0x80, 0xB5, 0xF9, 0x7E, 0xB5, 0xF8, 0x7C, 0xB5, 0xF8, 0x7C, 0xB5, 0xF9, 0x7E, 0xB2, 0xF9, 0x7E, 0xB3, 0xF9, 0x7D, 0xB4, 0xFA, 0x7B, 0xB4, 0xF9, 0x7A, 0xB5, 0xF7, 0x7D, 0xB4, 0xF9, 0x7E, 0xB5, 0xF8, 0x7E, 0xB5, 0xF7, 0x7E, 0xB7, 0xFB, 0x93, 0xB2, 0xEA, 0xD2, 0xC8, 0xD8, 0xF4, 0xF6, 0xF8, 0x8B, 0x99, 0xA7, 0xA1, 0x9D, 0xA7, 0xCC, 0xCF, 0xC2, 0xAF, 0xB9, 0xA7, 0x8D, 0x9A, 0xAC, 0x9D, 0xAF, 0xD8, 0x97, 0xAB, 0xD2, 0xA2, 0xAE, 0xC3, 0x8C, 0x92, 0x9D, 0x86, 0x7F, 0x86, 0x99, 0x8D, 0xA0, 0xB7, 0xBF, 0xE1, 0xB5, 0xCA, 0xEC, 0xBB, 0xCE, 0xEB, 0xD3, 0xD4, 0xE7, 0xDF, 0xE5, 0xE5, 0xC7, 0xCC, 0xCE, 0xCE, 0xD2, 0xCE, 0xCA, 0xD6, 0xD6, 0x8E, 0xA5, 0xCB, 0x99, 0xB9, 0xEF, 0x92, 0xB2, 0xDB, 0x91, 0x99, 0x9F, 0x98, 0x94, 0x8F, 0x84, 0x84, 0x87, 0x7C, 0x86, 0xA0, 0x95, 0xB3, 0xE2, 0x8C, 0xB4, 0xEE, 0x96, 0xB8, 0xF3, 0x9C, 0xB9, 0xF0, 0xA9, 0xB5, 0xD6, 0xC8, 0xC6, 0xC9, 0xAA, 0xA9, 0xB0, 0x99, 0xA9, 0xA1, 0x73, 0x85, 0x82, 0x38, 0x3C, 0x49, 0x39, 0x38, 0x4A, 0x41, 0x4C, 0x63, 0x59, 0x67, 0x8D, 0x9E, 0x9B, 0xB7, 0xFA, 0xF6, 0xFB, 0xD5, 0xDD, 0xDE, 0x83, 0x9F, 0xC5, 0x83, 0xB6, 0xF7, 0x7E, 0xB5, 0xF5, 0x7C, 0xB5, 0xF7, 0x7B, 0xB7, 0xF7, 0x7D, 0xB5, 0xF8, 0x7F, 0xB6, 0xF9, 0x7F, 0xB4, 0xF8, 0x7F, 0xB5, 0xF9, 0x7C, 0xB5, 0xF8, 0x7F, 0xB4, 0xFA, 0x7F, 0xB4, 0xFA, 0x7D, 0xB3, 0xF9, 0x7D, 0xB5, 0xF9, 0x7C, 0xB7, 0xF9, 0x7D, 0xB5, 0xFA, 0x7F, 0xB4, 0xFA, 0x7F, 0xB5, 0xF8, 0x7D, 0xB7, 0xFB, 0x95, 0xAF, 0xE9, 0xD8, 0xCA, 0xD9, 0xFD, 0xFE, 0xFD, 0x95, 0xA2, 0xB2, 0xA3, 0x9F, 0xAB, 0xC8, 0xCC, 0xBE, 0xAF, 0xB9, 0xA6, 0x8E, 0x9A, 0xAD, 0x9E, 0xAE, 0xD4, 0xA9, 0xB9, 0xD4, 0xA1, 0xAD, 0xB4, 0x79, 0x83, 0x89, 0x73, 0x71, 0x7B, 0x73, 0x75, 0x94, 0x92, 0xAF, 0xDD, 0x89, 0xB1, 0xE6, 0x8D, 0xAF, 0xE6, 0xB2, 0xB7, 0xDA, 0xE3, 0xE5, 0xE8, 0xC5, 0xCA, 0xCC, 0xCD, 0xCF, 0xCC, 0xC8, 0xD3, 0xD6, 0x8D, 0xAA, 0xDB, 0x88, 0xB2, 0xF3, 0x79, 0xA1, 0xD1, 0x4D, 0x55, 0x64, 0x7E, 0x7B, 0x79, 0x85, 0x87, 0x8A, 0x50, 0x5A, 0x73, 0x7F, 0x9E, 0xCE, 0x76, 0xA3, 0xE0, 0x78, 0xA3, 0xDF, 0x85, 0xA8, 0xE0, 0xA1, 0xAE, 0xCF, 0xCA, 0xCA, 0xCD, 0xAA, 0xAB, 0xB2, 0x99, 0xA6, 0x9C, 0x7B, 0x8E, 0x90, 0x48, 0x56, 0x68, 0x40, 0x48, 0x56, 0x3C, 0x49, 0x5A, 0x59, 0x68, 0x87, 0x97, 0x94, 0xB2, 0xF5, 0xF2, 0xF6, 0xD6, 0xDE, 0xE0, 0x84, 0xA0, 0xC6, 0x84, 0xB7, 0xF7, 0x7E, 0xB6, 0xF5, 0x7D, 0xB5, 0xF7, 0x7C, 0xB6, 0xF8, 0x7E, 0xB5, 0xF9, 0x7F, 0xB6, 0xF9, 0x7F, 0xB5, 0xF8, 0x7F, 0xB5, 0xF8, 0x7D, 0xB5, 0xF8, 0x7E, 0xB4, 0xFA, 0x7E, 0xB4, 0xFA, 0x7E, 0xB4, 0xFA, 0x7E, 0xB4, 0xFA, 0x7D, 0xB6, 0xF8, 0x7C, 0xB6, 0xFA, 0x81, 0xB3, 0xFA, 0x80, 0xB5, 0xF9, 0x7D, 0xB7, 0xFB, 0x99, 0xB0, 0xEB, 0xD8, 0xC8, 0xD8, 0xFF, 0xFF, 0xFF, 0xB7, 0xC4, 0xCE, 0xB8, 0xB3, 0xBF, 0xC5, 0xC9, 0xB9, 0xAE, 0xB8, 0xA3, 0x86, 0x8F, 0xA5, 0x73, 0x84, 0xB4, 0x93, 0xA3, 0xC2, 0x89, 0x94, 0x99, 0x3C, 0x41, 0x48, 0x41, 0x36, 0x44, 0x5C, 0x5A, 0x7E, 0x9D, 0xB9, 0xEF, 0x8E, 0xB3, 0xED, 0x92, 0xB0, 0xEB, 0xB7, 0xB8, 0xE0, 0xE4, 0xE5, 0xEA, 0xC8, 0xC6, 0xC8, 0xCC, 0xCB, 0xC9, 0xCB, 0xD4, 0xD9, 0x99, 0xB0, 0xDF, 0x92, 0xB1, 0xF2, 0x8A, 0xA6, 0xD5, 0x61, 0x5E, 0x71, 0x91, 0x85, 0x89, 0x91, 0x8B, 0x92, 0x45, 0x4B, 0x65, 0x93, 0xB0, 0xE4, 0x87, 0xB6, 0xF8, 0x83, 0xB6, 0xF3, 0x87, 0xB0, 0xEB, 0x9A, 0xA7, 0xCC, 0xC9, 0xCA, 0xCE, 0xAA, 0xAC, 0xB5, 0x93, 0xA0, 0x94, 0x81, 0x96, 0x97, 0x52, 0x64, 0x7F, 0x3A, 0x42, 0x56, 0x40, 0x49, 0x59, 0x4A, 0x56, 0x71, 0x8D, 0x89, 0xA8, 0xF1, 0xEC, 0xF0, 0xD6, 0xDE, 0xDF, 0x86, 0xA2, 0xC8, 0x87, 0xB8, 0xFA, 0x80, 0xB6, 0xF7, 0x7E, 0xB5, 0xF8, 0x7B, 0xB4, 0xF8, 0x7E, 0xB4, 0xF9, 0x7F, 0xB5, 0xF9, 0x7D, 0xB5, 0xF8, 0x7D, 0xB6, 0xF9, 0x7E, 0xB5, 0xF8, 0x7E, 0xB4, 0xFA, 0x7D, 0xB3, 0xF9, 0x7D, 0xB3, 0xF9, 0x7E, 0xB4, 0xF9, 0x7E, 0xB5, 0xF8, 0x7D, 0xB6, 0xF8, 0x81, 0xB3, 0xFA, 0x80, 0xB5, 0xF9, 0x7E, 0xB8, 0xFB, 0x9C, 0xB1, 0xEC, 0xDB, 0xCA, 0xD9, 0xFF, 0xFF, 0xFE, 0xB5, 0xC3, 0xCB, 0xAD, 0xAA, 0xB4, 0xC7, 0xCB, 0xBC, 0xB2, 0xBB, 0xA8, 0x86, 0x8E, 0xA4, 0x8D, 0x92, 0xC3, 0x88, 0x88, 0xAA, 0x5D, 0x59, 0x67, 0x3B, 0x31, 0x3E, 0x4D, 0x34, 0x3F, 0x6D, 0x62, 0x74, 0x92, 0x9D, 0xBE, 0x96, 0xA1, 0xC3, 0x9E, 0xA6, 0xC4, 0xBE, 0xBD, 0xD1, 0xDE, 0xE3, 0xE5, 0xC6, 0xC6, 0xC7, 0xCD, 0xCE, 0xCA, 0xD4, 0xDC, 0xDA, 0xA6, 0xB1, 0xD0, 0xA2, 0xAF, 0xD8, 0x9A, 0xA6, 0xC1, 0x86, 0x7C, 0x84, 0x9D, 0x91, 0x90, 0x86, 0x82, 0x82, 0x55, 0x59, 0x6A, 0x92, 0xA7, 0xD2, 0x8A, 0xAF, 0xE8, 0x89, 0xB0, 0xE7, 0x8C, 0xAD, 0xE0, 0x9B, 0xA6, 0xC1, 0xC6, 0xC8, 0xCA, 0xA6, 0xA9, 0xB2, 0x94, 0xA0, 0x96, 0x80, 0x95, 0xA0, 0x55, 0x65, 0x8A, 0x34, 0x36, 0x4F, 0x41, 0x44, 0x57, 0x4D, 0x52, 0x70, 0x90, 0x89, 0xA9, 0xF1, 0xEE, 0xEE, 0xD8, 0xE1, 0xE2, 0x86, 0xA1, 0xC9, 0x86, 0xB8, 0xFA, 0x82, 0xB6, 0xF8, 0x7F, 0xB4, 0xFA, 0x7C, 0xB5, 0xF9, 0x7E, 0xB4, 0xFB, 0x7F, 0xB5, 0xFB, 0x7D, 0xB6, 0xFA, 0x7D, 0xB6, 0xF9, 0x7E, 0xB6, 0xF9, 0x7D, 0xB6, 0xFA, 0x7F, 0xB6, 0xF8, 0x7F, 0xB4, 0xF7, 0x80, 0xB5, 0xF8, 0x80, 0xB5, 0xF9, 0x81, 0xB5, 0xF8, 0x7E, 0xB6, 0xFC, 0x7E, 0xB5, 0xFB, 0x7D, 0xB8, 0xFA, 0x9C, 0xB4, 0xED, 0xD9, 0xCC, 0xD5, 0xFF, 0xFF, 0xFE, 0xA2, 0xAD, 0xB6, 0xA2, 0x9C, 0xA9, 0xC8, 0xCC, 0xC2, 0xB5, 0xBA, 0xAF, 0x9A, 0x97, 0xA6, 0xB2, 0xAE, 0xC9, 0xB8, 0xB7, 0xCC, 0x9D, 0x9C, 0xA7, 0xA0, 0x96, 0x9C, 0xB8, 0xAE, 0xB4, 0xD0, 0xD0, 0xD4, 0xD5, 0xD9, 0xDD, 0xDE, 0xDE, 0xE5, 0xE4, 0xE6, 0xEA, 0xF1, 0xF4, 0xF5, 0xDC, 0xDC, 0xE2, 0xC2, 0xC2, 0xC1, 0xCD, 0xCE, 0xCB, 0xCD, 0xCF, 0xD2, 0xB9, 0xC0, 0xC6, 0xED, 0xF6, 0xFA, 0xE3, 0xED, 0xEF, 0xD5, 0xDE, 0xDC, 0xD5, 0xDA, 0xDA, 0xC3, 0xC6, 0xC9, 0xA4, 0xAA, 0xB4, 0xA8, 0xB3, 0xC8, 0x97, 0xA5, 0xC3, 0x81, 0x8F, 0xB1, 0x7A, 0x83, 0xA2, 0x9A, 0x97, 0xA5, 0xC8, 0xCA, 0xD1, 0xA2, 0xA6, 0xAC, 0x94, 0x9F, 0x93, 0x88, 0x9B, 0xAC, 0x7B, 0x8C, 0xB9, 0x50, 0x53, 0x6D, 0x4B, 0x51, 0x67, 0x5B, 0x61, 0x8C, 0x8E, 0x88, 0xA7, 0xE8, 0xE8, 0xE3, 0xD8, 0xE0, 0xE6, 0x82, 0x9E, 0xC7, 0x84, 0xBA, 0xFA, 0x7E, 0xB7, 0xF8, 0x7E, 0xB4, 0xFC, 0x7C, 0xB5, 0xFB, 0x7D, 0xB4, 0xFB, 0x7F, 0xB4, 0xFA, 0x7F, 0xB5, 0xFB, 0x80, 0xB5, 0xFA, 0x80, 0xB5, 0xF9, 0x7E, 0xB5, 0xFA, 0x7E, 0xB5, 0xF8, 0x80, 0xB5, 0xF9, 0x7F, 0xB4, 0xF8, 0x7F, 0xB4, 0xF8, 0x80, 0xB4, 0xF7, 0x7D, 0xB5, 0xFB, 0x7E, 0xB5, 0xFA, 0x7E, 0xB7, 0xF9, 0x9A, 0xB2, 0xEB, 0xD6, 0xCB, 0xD5, 0xFF, 0xFF, 0xFF, 0xA5, 0xB1, 0xBA, 0xAC, 0xA6, 0xB1, 0xCE, 0xD0, 0xC3, 0xB2, 0xB8, 0xAB, 0xB1, 0xB7, 0xC1, 0xD9, 0xE2, 0xEF, 0xD9, 0xE7, 0xEF, 0xCC, 0xDB, 0xDE, 0xC8, 0xD0, 0xD1, 0xC3, 0xC8, 0xC8, 0xB5, 0xBE, 0xBE, 0x9E, 0xAB, 0xAA, 0x9C, 0xA8, 0xA9, 0xA4, 0xAB, 0xAB, 0xCB, 0xCE, 0xCE, 0xDE, 0xDF, 0xE4, 0xC5, 0xC6, 0xC5, 0xD0, 0xD2, 0xCC, 0xC2, 0xC4, 0xC3, 0x68, 0x70, 0x73, 0x82, 0x8D, 0x91, 0x84, 0x92, 0x95, 0x85, 0x8F, 0x91, 0x86, 0x94, 0x96, 0x90, 0x9F, 0xA2, 0x96, 0xA4, 0xA8, 0x9E, 0xA9, 0xB3, 0xA7, 0xB0, 0xBD, 0xB6, 0xBA, 0xC5, 0xC7, 0xCD, 0xD7, 0xD6, 0xD8, 0xDA, 0xD7, 0xD9, 0xDC, 0x9D, 0xA1, 0xA5, 0x93, 0xA1, 0x96, 0x8B, 0x9E, 0xAA, 0x8D, 0xA6, 0xCE, 0x8A, 0x9A, 0xB5, 0x5C, 0x6E, 0x87, 0x53, 0x61, 0x8B, 0x8A, 0x84, 0xA1, 0xE5, 0xE0, 0xDB, 0xD8, 0xDD, 0xE3, 0x83, 0xA0, 0xCB, 0x83, 0xB9, 0xF8, 0x7E, 0xB7, 0xF8, 0x7E, 0xB5, 0xFC, 0x7C, 0xB6, 0xFC, 0x7E, 0xB5, 0xFC, 0x7F, 0xB5, 0xFB, 0x7E, 0xB4, 0xFA, 0x7F, 0xB5, 0xFB, 0x7F, 0xB5, 0xFA, 0x7F, 0xB5, 0xF8, 0x7E, 0xB5, 0xF8, 0x80, 0xB6, 0xF9, 0x7F, 0xB4, 0xF8, 0x80, 0xB4, 0xF9, 0x80, 0xB4, 0xF7, 0x7D, 0xB5, 0xFB, 0x7F, 0xB5, 0xF9, 0x7F, 0xB7, 0xF9, 0x9A, 0xB3, 0xEC, 0xD5, 0xCB, 0xD5, 0xFD, 0xFE, 0xFD, 0xB3, 0xC1, 0xCD, 0xC1, 0xBA, 0xC3, 0xCF, 0xD0, 0xC0, 0xB2, 0xBB, 0xAB, 0x9B, 0xAB, 0xAF, 0x6D, 0x7D, 0x7F, 0x5D, 0x6E, 0x6F, 0x5A, 0x6D, 0x6C, 0x37, 0x45, 0x46, 0x2B, 0x33, 0x34, 0x22, 0x2B, 0x2A, 0x1B, 0x25, 0x24, 0x19, 0x24, 0x24, 0x20, 0x23, 0x23, 0x74, 0x6F, 0x6F, 0xE7, 0xE6, 0xEA, 0xCA, 0xCC, 0xC9, 0xD7, 0xD7, 0xCF, 0xC0, 0xC1, 0xBD, 0x29, 0x2E, 0x30, 0x15, 0x1F, 0x24, 0x14, 0x1F, 0x23, 0x13, 0x1C, 0x20, 0x11, 0x1D, 0x1E, 0x13, 0x1D, 0x1F, 0x15, 0x20, 0x21, 0x18, 0x23, 0x28, 0x1E, 0x27, 0x2E, 0x2D, 0x32, 0x38, 0x3E, 0x44, 0x46, 0x8D, 0x8F, 0x8B, 0xD3, 0xD3, 0xD3, 0x9F, 0xA0, 0xA4, 0x9D, 0xAB, 0x9F, 0x69, 0x79, 0x7A, 0x48, 0x61, 0x7A, 0x66, 0x7E, 0x94, 0x5D, 0x77, 0x8C, 0x45, 0x59, 0x7E, 0x8D, 0x87, 0xA0, 0xE0, 0xDB, 0xD7, 0xD4, 0xD9, 0xDE, 0x85, 0xA2, 0xCF, 0x81, 0xB7, 0xF9, 0x7E, 0xB7, 0xF8, 0x7C, 0xB5, 0xFB, 0x7B, 0xB6, 0xFB, 0x7E, 0xB5, 0xFB, 0x7E, 0xB4, 0xFA, 0x7E, 0xB4, 0xFA, 0x7F, 0xB5, 0xFB, 0x7F, 0xB5, 0xFB, 0x7F, 0xB5, 0xF8, 0x7E, 0xB5, 0xF8, 0x7E, 0xB5, 0xF9, 0x7F, 0xB5, 0xF9, 0x80, 0xB5, 0xF9, 0x81, 0xB5, 0xF8, 0x7F, 0xB5, 0xFB, 0x80, 0xB4, 0xF8, 0x7E, 0xB7, 0xF8, 0x9A, 0xB3, 0xEB, 0xD7, 0xCD, 0xD7, 0xFC, 0xFE, 0xFC, 0xAF, 0xC0, 0xCE, 0xB3, 0xAE, 0xB7, 0xCF, 0xCF, 0xBA, 0xAE, 0xB6, 0xA6, 0x82, 0x94, 0x96, 0x30, 0x3C, 0x3D, 0x20, 0x27, 0x29, 0x39, 0x41, 0x44, 0x33, 0x39, 0x3C, 0x32, 0x34, 0x37, 0x33, 0x32, 0x35, 0x2F, 0x2D, 0x31, 0x28, 0x29, 0x2D, 0x28, 0x1F, 0x22, 0x75, 0x65, 0x66, 0xE7, 0xE3, 0xE5, 0xCC, 0xCC, 0xC9, 0xD7, 0xD4, 0xCE, 0xCA, 0xC9, 0xC6, 0x3C, 0x3D, 0x3F, 0x1F, 0x23, 0x2A, 0x1D, 0x22, 0x29, 0x1C, 0x20, 0x27, 0x1A, 0x1E, 0x25, 0x1A, 0x1F, 0x26, 0x1B, 0x20, 0x26, 0x19, 0x20, 0x27, 0x19, 0x20, 0x29, 0x1B, 0x1F, 0x29, 0x1C, 0x1B, 0x20, 0x66, 0x63, 0x62, 0xC4, 0xC3, 0xC6, 0xA9, 0xA9, 0xAE, 0x9E, 0xAE, 0xA0, 0x68, 0x73, 0x6A, 0x1A, 0x2A, 0x30, 0x29, 0x3B, 0x47, 0x35, 0x4E, 0x59, 0x4C, 0x5E, 0x78, 0x92, 0x8B, 0x9D, 0xDF, 0xDC, 0xDA, 0xCE, 0xD5, 0xDC, 0x86, 0xA2, 0xD0, 0x82, 0xB8, 0xFA, 0x7D, 0xB6, 0xF7, 0x7E, 0xB6, 0xFB, 0x7C, 0xB5, 0xF9, 0x7E, 0xB5, 0xFB, 0x7F, 0xB5, 0xFB, 0x7E, 0xB4, 0xFA, 0x7F, 0xB5, 0xFB, 0x7E, 0xB6, 0xFA, 0x80, 0xB5, 0xF9, 0x7E, 0xB5, 0xF9, 0x7C, 0xB4, 0xFA, 0x7D, 0xB5, 0xFA, 0x7F, 0xB6, 0xF9, 0x80, 0xB5, 0xF7, 0x7E, 0xB4, 0xF8, 0x81, 0xB6, 0xF8, 0x80, 0xB8, 0xF7, 0x98, 0xB1, 0xE8, 0xD8, 0xCF, 0xD9, 0xFF, 0xFF, 0xFF, 0x9A, 0xAC, 0xBC, 0x99, 0x98, 0x9E, 0xCD, 0xD0, 0xB6, 0xB6, 0xB9, 0xAC, 0x78, 0x86, 0x8C, 0x30, 0x3A, 0x3F, 0x1B, 0x1C, 0x23, 0x1D, 0x1D, 0x23, 0x24, 0x23, 0x29, 0x27, 0x26, 0x2C, 0x2A, 0x28, 0x2C, 0x2C, 0x27, 0x2D, 0x23, 0x24, 0x2B, 0x27, 0x1D, 0x20, 0x81, 0x6E, 0x6F, 0xE3, 0xDE, 0xE0, 0xC8, 0xC5, 0xC3, 0xD0, 0xCD, 0xC9, 0xEA, 0xEB, 0xEB, 0x4D, 0x4D, 0x52, 0x1D, 0x1F, 0x26, 0x1E, 0x1F, 0x27, 0x1E, 0x1D, 0x25, 0x19, 0x1C, 0x27, 0x1A, 0x1E, 0x28, 0x1B, 0x1C, 0x25, 0x1A, 0x1D, 0x25, 0x1B, 0x1D, 0x26, 0x20, 0x1D, 0x26, 0x26, 0x1F, 0x25, 0x6A, 0x64, 0x67, 0xB7, 0xB7, 0xBB, 0xA7, 0xAC, 0xAF, 0x95, 0xA9, 0x9C, 0x69, 0x6F, 0x64, 0x19, 0x1F, 0x1D, 0x19, 0x1F, 0x29, 0x18, 0x24, 0x2C, 0x2C, 0x32, 0x44, 0x65, 0x55, 0x60, 0xE0, 0xD9, 0xDA, 0xCB, 0xD3, 0xDA, 0x87, 0xA0, 0xCF, 0x84, 0xB9, 0xFA, 0x7E, 0xB5, 0xF7, 0x7F, 0xB5, 0xFB, 0x7D, 0xB6, 0xF9, 0x7D, 0xB6, 0xF9, 0x7E, 0xB6, 0xFA, 0x7E, 0xB5, 0xF9, 0x7F, 0xB6, 0xF9, 0x7F, 0xB6, 0xF9, 0x80, 0xB5, 0xF9, 0x7E, 0xB6, 0xFA, 0x7C, 0xB6, 0xFB, 0x7D, 0xB6, 0xFA, 0x7E, 0xB5, 0xF8, 0x81, 0xB4, 0xF7, 0x7F, 0xB5, 0xF8, 0x81, 0xB6, 0xF7, 0x81, 0xB8, 0xF8, 0x99, 0xB2, 0xE7, 0xD8, 0xD1, 0xD9, 0xFF, 0xFF, 0xFF, 0x91, 0xA5, 0xB6, 0x9C, 0xA1, 0xA8, 0xCB, 0xCD, 0xB4, 0xC5, 0xC8, 0xBF, 0x85, 0x90, 0x99, 0x39, 0x44, 0x4B, 0x1D, 0x20, 0x29, 0x23, 0x24, 0x2A, 0x26, 0x28, 0x2D, 0x28, 0x2B, 0x2E, 0x2B, 0x2C, 0x30, 0x29, 0x28, 0x30, 0x1E, 0x23, 0x2B, 0x1C, 0x19, 0x1B, 0x7E, 0x71, 0x70, 0xF6, 0xF3, 0xF3, 0xE2, 0xDD, 0xD8, 0xEA, 0xE8, 0xE5, 0xE8, 0xEE, 0xEF, 0x49, 0x4D, 0x51, 0x21, 0x23, 0x29, 0x20, 0x21, 0x28, 0x2C, 0x2A, 0x32, 0x29, 0x27, 0x2E, 0x1F, 0x1F, 0x24, 0x1E, 0x1E, 0x23, 0x1B, 0x1D, 0x24, 0x1B, 0x1D, 0x27, 0x1C, 0x1B, 0x25, 0x2A, 0x23, 0x2A, 0x74, 0x6F, 0x72, 0xA7, 0xAB, 0xB0, 0xAB, 0xB5, 0xB8, 0x97, 0xB0, 0xA5, 0x65, 0x6B, 0x64, 0x1E, 0x1E, 0x20, 0x1F, 0x1F, 0x2C, 0x1D, 0x21, 0x2A, 0x21, 0x1D, 0x2D, 0x53, 0x3C, 0x46, 0xE3, 0xD9, 0xDA, 0xCD, 0xD4, 0xDB, 0x85, 0x9F, 0xCF, 0x84, 0xB8, 0xFB, 0x7F, 0xB6, 0xF7, 0x7F, 0xB5, 0xFB, 0x7E, 0xB6, 0xF9, 0x7E, 0xB6, 0xF9, 0x7C, 0xB5, 0xF8, 0x7E, 0xB6, 0xF9, 0x7F, 0xB6, 0xF9, 0x7F, 0xB5, 0xF9, 0x7D, 0xB5, 0xFB, 0x7E, 0xB6, 0xF9, 0x7F, 0xB6, 0xF9, 0x80, 0xB5, 0xF9, 0x81, 0xB5, 0xF9, 0x83, 0xB4, 0xFB, 0x80, 0xB5, 0xF9, 0x81, 0xB7, 0xF6, 0x80, 0xB7, 0xFD, 0x9D, 0xB2, 0xE5, 0xD9, 0xD3, 0xDC, 0xFA, 0xFE, 0xFC, 0x9E, 0xB6, 0xC9, 0xA1, 0xB6, 0xC9, 0xAC, 0xAC, 0xA0, 0xBF, 0xC3, 0xC1, 0x90, 0x9B, 0xA4, 0x55, 0x60, 0x68, 0x1F, 0x20, 0x30, 0x21, 0x21, 0x2C, 0x1E, 0x24, 0x2B, 0x23, 0x25, 0x2A, 0x26, 0x23, 0x31, 0x27, 0x23, 0x30, 0x29, 0x21, 0x2C, 0x27, 0x1D, 0x23, 0x4D, 0x45, 0x48, 0xAB, 0xA7, 0xA5, 0xB3, 0xB2, 0xA7, 0xA9, 0xAA, 0xA3, 0x80, 0x91, 0x8E, 0x36, 0x3C, 0x3F, 0x24, 0x25, 0x2A, 0x1D, 0x22, 0x25, 0x31, 0x31, 0x36, 0x33, 0x2F, 0x37, 0x21, 0x21, 0x25, 0x20, 0x21, 0x24, 0x23, 0x1D, 0x28, 0x20, 0x1D, 0x2B, 0x20, 0x1B, 0x24, 0x3D, 0x2F, 0x3A, 0x7E, 0x7D, 0x82, 0x9B, 0xA4, 0xAB, 0x83, 0x90, 0x97, 0x72, 0x8E, 0x86, 0x56, 0x5F, 0x63, 0x1D, 0x1A, 0x2B, 0x1D, 0x1F, 0x25, 0x1F, 0x1F, 0x2B, 0x2C, 0x25, 0x3C, 0x66, 0x58, 0x6E, 0xDC, 0xDB, 0xD8, 0xC9, 0xD6, 0xD9, 0x7E, 0x9F, 0xD1, 0x82, 0xB8, 0xFC, 0x80, 0xB6, 0xF7, 0x7F, 0xB5, 0xFA, 0x7D, 0xB8, 0xF8, 0x7E, 0xB7, 0xF8, 0x7F, 0xB6, 0xF9, 0x7D, 0xB6, 0xF9, 0x7C, 0xB7, 0xFA, 0x7D, 0xB6, 0xF9, 0x7F, 0xB4, 0xF9, 0x7F, 0xB6, 0xF8, 0x7E, 0xB5, 0xF8, 0x80, 0xB5, 0xF9, 0x80, 0xB5, 0xF9, 0x80, 0xB5, 0xF9, 0x7F, 0xB7, 0xFA, 0x80, 0xB6, 0xF7, 0x80, 0xB6, 0xFD, 0x9B, 0xB3, 0xE8, 0xD8, 0xD4, 0xDF, 0xF5, 0xFA, 0xFA, 0x99, 0xB0, 0xC1, 0x8B, 0xA2, 0xBD, 0x76, 0x7F, 0x83, 0x84, 0x86, 0x81, 0x90, 0x91, 0x96, 0x87, 0x8C, 0x9E, 0x4E, 0x4E, 0x68, 0x28, 0x24, 0x35, 0x1D, 0x1B, 0x24, 0x22, 0x1A, 0x24, 0x23, 0x1B, 0x34, 0x21, 0x1C, 0x31, 0x2B, 0x1A, 0x2A, 0x33, 0x18, 0x24, 0x35, 0x23, 0x28, 0x68, 0x67, 0x65, 0x64, 0x69, 0x60, 0x59, 0x61, 0x55, 0x43, 0x55, 0x4C, 0x2B, 0x2F, 0x38, 0x20, 0x1F, 0x2C, 0x16, 0x19, 0x20, 0x1A, 0x19, 0x18, 0x22, 0x19, 0x1E, 0x23, 0x1D, 0x22, 0x25, 0x1D, 0x20, 0x26, 0x1A, 0x25, 0x25, 0x1B, 0x2B, 0x24, 0x16, 0x23, 0x52, 0x3E, 0x4A, 0x8A, 0x86, 0x8D, 0x6F, 0x7B, 0x7E, 0x4C, 0x5A, 0x5D, 0x3C, 0x4A, 0x4D, 0x2B, 0x33, 0x4B, 0x1F, 0x22, 0x46, 0x20, 0x22, 0x2E, 0x1F, 0x1F, 0x29, 0x49, 0x45, 0x60, 0x9D, 0x93, 0xAD, 0xD6, 0xD7, 0xDA, 0xB6, 0xC5, 0xCF, 0x80, 0xA3, 0xD4, 0x83, 0xB7, 0xFA, 0x80, 0xB7, 0xF8, 0x7F, 0xB5, 0xFB, 0x7E, 0xB7, 0xF8, 0x7E, 0xB6, 0xF8, 0x7E, 0xB6, 0xF9, 0x7C, 0xB6, 0xFA, 0x7D, 0xB6, 0xFB, 0x7F, 0xB7, 0xFA, 0x80, 0xB5, 0xF9, 0x80, 0xB5, 0xF9, 0x80, 0xB6, 0xF9, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x80, 0xB7, 0xF9, 0x7F, 0xB7, 0xF9, 0x82, 0xB6, 0xF8, 0x84, 0xB7, 0xFB, 0x98, 0xB2, 0xE8, 0xD5, 0xD4, 0xDE, 0xE5, 0xEC, 0xEB, 0x9F, 0xAD, 0xB8, 0x8F, 0xA2, 0xCA, 0x77, 0x87, 0xA4, 0x79, 0x7A, 0x75, 0x78, 0x73, 0x6E, 0x8A, 0x8F, 0x9A, 0x85, 0x86, 0x9A, 0x51, 0x4E, 0x58, 0x41, 0x3D, 0x3F, 0x54, 0x4E, 0x53, 0x7D, 0x7D, 0x9A, 0x84, 0x89, 0xA8, 0x86, 0x7A, 0x97, 0x92, 0x7C, 0x95, 0x98, 0x8F, 0xA1, 0x83, 0x88, 0x8E, 0x63, 0x66, 0x5D, 0x60, 0x66, 0x56, 0x4A, 0x50, 0x4B, 0x30, 0x2E, 0x48, 0x36, 0x37, 0x5B, 0x4A, 0x4D, 0x68, 0x53, 0x4F, 0x59, 0x59, 0x53, 0x56, 0x55, 0x4C, 0x53, 0x45, 0x3B, 0x48, 0x32, 0x29, 0x46, 0x2F, 0x27, 0x4A, 0x38, 0x2A, 0x45, 0x7A, 0x6C, 0x7A, 0x8E, 0x8F, 0x93, 0x64, 0x70, 0x71, 0x57, 0x5F, 0x63, 0x5F, 0x64, 0x78, 0x7C, 0x8F, 0xBD, 0x57, 0x6E, 0xA4, 0x18, 0x21, 0x32, 0x24, 0x24, 0x2D, 0x4A, 0x45, 0x63, 0x97, 0x92, 0xAB, 0xD8, 0xE1, 0xE4, 0xA2, 0xB6, 0xC9, 0x7C, 0xA2, 0xD5, 0x82, 0xB7, 0xF8, 0x81, 0xB6, 0xF9, 0x80, 0xB6, 0xFB, 0x81, 0xB7, 0xFA, 0x7F, 0xB6, 0xFA, 0x7D, 0xB6, 0xF9, 0x7C, 0xB5, 0xFA, 0x7D, 0xB6, 0xFB, 0x7F, 0xB6, 0xFB, 0x80, 0xB5, 0xF9, 0x7F, 0xB4, 0xF8, 0x7F, 0xB5, 0xF9, 0x80, 0xB5, 0xF9, 0x80, 0xB5, 0xF9, 0x80, 0xB5, 0xFB, 0x81, 0xB4, 0xFB, 0x83, 0xB5, 0xF9, 0x85, 0xB6, 0xF6, 0x8E, 0xB2, 0xE7, 0xD2, 0xDA, 0xE7, 0xE9, 0xEC, 0xEB, 0xCD, 0xCE, 0xD4, 0xA0, 0xA9, 0xD4, 0x8B, 0x9A, 0xC6, 0x7C, 0x7F, 0x85, 0x79, 0x78, 0x6B, 0x7B, 0x7F, 0x7B, 0x92, 0x93, 0x9F, 0x93, 0x95, 0x9D, 0xA1, 0xA0, 0xA3, 0x8E, 0x8C, 0x94, 0x9B, 0xA7, 0xCE, 0x9D, 0xBA, 0xEB, 0xA4, 0xBA, 0xEB, 0xAA, 0xB9, 0xED, 0xA8, 0xBF, 0xEF, 0x7D, 0x93, 0xB1, 0x63, 0x65, 0x64, 0x62, 0x66, 0x57, 0x57, 0x5A, 0x59, 0x79, 0x7F, 0xAB, 0x87, 0x9C, 0xD7, 0x85, 0x9C, 0xCE, 0x55, 0x60, 0x7D, 0x5E, 0x5F, 0x63, 0x62, 0x5F, 0x66, 0x6E, 0x6D, 0x8B, 0x76, 0x7C, 0xB4, 0x6C, 0x70, 0xAC, 0x81, 0x7D, 0xA4, 0xA6, 0xAA, 0xB5, 0x84, 0x90, 0x91, 0x4E, 0x57, 0x5A, 0x31, 0x33, 0x43, 0x52, 0x5B, 0x85, 0xA0, 0xC5, 0xFE, 0x63, 0x8A, 0xC1, 0x10, 0x20, 0x33, 0x2B, 0x29, 0x35, 0x4B, 0x46, 0x61, 0x98, 0x9A, 0xAD, 0xC7, 0xD8, 0xDC, 0x7C, 0x98, 0xB3, 0x74, 0x9C, 0xD4, 0x83, 0xB8, 0xF9, 0x81, 0xB6, 0xFC, 0x80, 0xB7, 0xFA, 0x80, 0xB6, 0xF9, 0x7F, 0xB5, 0xFB, 0x7D, 0xB6, 0xF9, 0x7D, 0xB5, 0xFA, 0x7E, 0xB5, 0xFB, 0x80, 0xB5, 0xFB, 0x7F, 0xB6, 0xF9, 0x7F, 0xB6, 0xF9, 0x7F, 0xB6, 0xF9, 0x80, 0xB5, 0xF9, 0x80, 0xB5, 0xF7, 0x81, 0xB4, 0xFB, 0x82, 0xB4, 0xFA, 0x82, 0xB6, 0xF9, 0x84, 0xB6, 0xF6, 0x83, 0xB3, 0xF1, 0xAF, 0xC5, 0xE4, 0xE8, 0xE9, 0xEB, 0xEB, 0xE6, 0xE8, 0xB0, 0xB2, 0xCA, 0xA6, 0xAE, 0xD2, 0x81, 0x84, 0x99, 0x7D, 0x7F, 0x78, 0x7A, 0x7B, 0x6D, 0x8B, 0x8B, 0x92, 0x5B, 0x5F, 0x6B, 0x2F, 0x2F, 0x38, 0x28, 0x24, 0x32, 0x6D, 0x7B, 0xA8, 0x8F, 0xB6, 0xF0, 0x85, 0xAF, 0xE9, 0x86, 0xAE, 0xEE, 0x87, 0xB0, 0xF0, 0x7B, 0x98, 0xC3, 0x65, 0x6C, 0x72, 0x62, 0x69, 0x5B, 0x56, 0x59, 0x59, 0x84, 0x9B, 0xCC, 0x8D, 0xBE, 0xFF, 0x76, 0xA3, 0xDC, 0x15, 0x2A, 0x4C, 0x1F, 0x23, 0x28, 0x20, 0x1E, 0x2A, 0x56, 0x5E, 0x83, 0x9C, 0xB6, 0xF5, 0x95, 0xAC, 0xEB, 0x9F, 0xAA, 0xCD, 0x97, 0xA4, 0xAE, 0x6C, 0x7B, 0x7F, 0x3C, 0x41, 0x49, 0x39, 0x3D, 0x5F, 0x55, 0x71, 0xAD, 0x5D, 0x8B, 0xC9, 0x49, 0x6B, 0x97, 0x1F, 0x23, 0x37, 0x2F, 0x26, 0x38, 0x55, 0x57, 0x6B, 0x9E, 0xAD, 0xBF, 0x92, 0xA7, 0xB6, 0x57, 0x74, 0x9D, 0x80, 0xAD, 0xEB, 0x82, 0xB8, 0xFA, 0x80, 0xB5, 0xFC, 0x7E, 0xB6, 0xF9, 0x80, 0xB6, 0xF9, 0x81, 0xB5, 0xFC, 0x7F, 0xB5, 0xFA, 0x7F, 0xB4, 0xFB, 0x7F, 0xB5, 0xFB, 0x7F, 0xB5, 0xFB, 0x7E, 0xB6, 0xF9, 0x7E, 0xB6, 0xF9, 0x80, 0xB7, 0xFA, 0x81, 0xB6, 0xF8, 0x81, 0xB6, 0xF8, 0x81, 0xB5, 0xFA, 0x81, 0xB5, 0xF8, 0x81, 0xB7, 0xF9, 0x81, 0xB7, 0xF8, 0x7F, 0xB7, 0xFD, 0x8E, 0xB2, 0xE5, 0xC7, 0xCC, 0xD9, 0xFF, 0xFD, 0xFC, 0xEA, 0xEA, 0xED, 0xAB, 0xAD, 0xBE, 0x97, 0x98, 0xB7, 0x87, 0x86, 0x8E, 0x84, 0x81, 0x6C, 0x83, 0x82, 0x7F, 0x7E, 0x80, 0x8B, 0x4A, 0x47, 0x4F, 0x32, 0x29, 0x34, 0x73, 0x7A, 0x9F, 0x9E, 0xB9, 0xEC, 0x91, 0xB2, 0xE4, 0x92, 0xB4, 0xE7, 0x97, 0xB7, 0xEA, 0x8C, 0x9F, 0xC4, 0x6A, 0x70, 0x70, 0x6A, 0x6D, 0x5E, 0x55, 0x52, 0x53, 0x77, 0x8F, 0xBE, 0x83, 0xBC, 0xFA, 0x75, 0xA3, 0xDC, 0x2C, 0x38, 0x54, 0x2B, 0x28, 0x31, 0x23, 0x20, 0x2F, 0x56, 0x63, 0x82, 0x96, 0xBA, 0xED, 0x92, 0xB1, 0xE5, 0x9E, 0xB0, 0xC9, 0x87, 0x98, 0x9F, 0x52, 0x5E, 0x65, 0x33, 0x34, 0x42, 0x65, 0x72, 0x9F, 0x89, 0xB6, 0xF7, 0x72, 0xA1, 0xE1, 0x43, 0x4B, 0x6D, 0x30, 0x1F, 0x33, 0x49, 0x3D, 0x54, 0x74, 0x81, 0x90, 0x6A, 0x81, 0x96, 0x44, 0x57, 0x79, 0x68, 0x84, 0xBA, 0x88, 0xB8, 0xF8, 0x81, 0xB7, 0xFA, 0x81, 0xB5, 0xFD, 0x7E, 0xB6, 0xFA, 0x80, 0xB6, 0xF9, 0x82, 0xB5, 0xFD, 0x81, 0xB6, 0xFC, 0x80, 0xB5, 0xFB, 0x7F, 0xB5, 0xFB, 0x7F, 0xB5, 0xFB, 0x80, 0xB5, 0xF9, 0x7F, 0xB6, 0xFA, 0x7F, 0xB5, 0xFB, 0x7F, 0xB6, 0xF9, 0x80, 0xB5, 0xF9, 0x80, 0xB6, 0xFB, 0x80, 0xB5, 0xF7, 0x83, 0xB6, 0xF7, 0x81, 0xB7, 0xFA, 0x7F, 0xB7, 0xFA, 0x84, 0xB7, 0xF6, 0x9B, 0xB1, 0xD8, 0xDF, 0xE5, 0xEC, 0xFF, 0xFF, 0xFF, 0xDD, 0xDB, 0xDF, 0xA5, 0xA3, 0xBA, 0x95, 0x91, 0xA5, 0x89, 0x87, 0x7D, 0x84, 0x81, 0x71, 0x8C, 0x8A, 0x89, 0x82, 0x7E, 0x84, 0x6F, 0x66, 0x6E, 0x8A, 0x8E, 0xA9, 0xB1, 0xC7, 0xED, 0xB2, 0xCD, 0xF0, 0xA0, 0xBC, 0xE9, 0xAB, 0xC8, 0xF1, 0x99, 0xAD, 0xD0, 0x69, 0x70, 0x75, 0x68, 0x6C, 0x60, 0x5A, 0x58, 0x55, 0x53, 0x65, 0x89, 0x5A, 0x8F, 0xC8, 0x54, 0x82, 0xB6, 0x6A, 0x74, 0x88, 0x80, 0x7C, 0x80, 0x72, 0x72, 0x79, 0x75, 0x7F, 0x98, 0x99, 0xAB, 0xD7, 0xA7, 0xB3, 0xD6, 0x9F, 0xAD, 0xBC, 0x71, 0x86, 0x88, 0x3F, 0x4B, 0x50, 0x43, 0x3E, 0x57, 0x84, 0xA4, 0xD6, 0x85, 0xBF, 0xF9, 0x82, 0xAA, 0xE3, 0x58, 0x3C, 0x51, 0x7C, 0x64, 0x6B, 0x6D, 0x75, 0x84, 0x6C, 0x7E, 0x92, 0x37, 0x46, 0x68, 0x4C, 0x60, 0x99, 0x87, 0xAE, 0xF1, 0x85, 0xB9, 0xFB, 0x82, 0xB7, 0xF9, 0x81, 0xB7, 0xFA, 0x81, 0xB6, 0xFA, 0x82, 0xB6, 0xFA, 0x82, 0xB5, 0xFB, 0x81, 0xB6, 0xFB, 0x7F, 0xB6, 0xF9, 0x7F, 0xB7, 0xF9, 0x80, 0xB7, 0xFA, 0x81, 0xB6, 0xFA, 0x7F, 0xB6, 0xFA, 0x80, 0xB6, 0xFC, 0x7F, 0xB6, 0xF9, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xF8, 0x82, 0xB6, 0xF8, 0x81, 0xB7, 0xFA, 0x7F, 0xB6, 0xF9, 0x82, 0xB7, 0xF8, 0x8E, 0xB6, 0xED, 0x9D, 0xB8, 0xD3, 0xDB, 0xE5, 0xEB, 0xFF, 0xFF, 0xFF, 0xDD, 0xD9, 0xDF, 0x92, 0x93, 0xA8, 0x83, 0x84, 0x8C, 0x8A, 0x8A, 0x79, 0x80, 0x82, 0x77, 0x92, 0x92, 0x96, 0x9A, 0x98, 0x98, 0x8B, 0x90, 0xA7, 0x98, 0xAE, 0xD8, 0xA5, 0xC7, 0xEE, 0x86, 0xAF, 0xE5, 0x87, 0xB2, 0xE9, 0x8A, 0xA5, 0xD2, 0x6D, 0x73, 0x7F, 0x6B, 0x6E, 0x65, 0x55, 0x57, 0x50, 0x5D, 0x6F, 0x8A, 0x8B, 0xBA, 0xF6, 0x5A, 0x85, 0xB1, 0x29, 0x30, 0x43, 0x42, 0x3E, 0x46, 0x3C, 0x3A, 0x46, 0x65, 0x6B, 0x81, 0x96, 0xA3, 0xC3, 0x9D, 0xA7, 0xBC, 0x91, 0xA0, 0xA4, 0x57, 0x66, 0x62, 0x38, 0x3A, 0x45, 0x50, 0x55, 0x75, 0x81, 0xA4, 0xD0, 0x85, 0xB9, 0xEA, 0x7B, 0x82, 0xA8, 0xA9, 0x87, 0x93, 0xF8, 0xF6, 0xF9, 0x7C, 0x95, 0x9A, 0x3A, 0x4C, 0x6B, 0x4A, 0x5D, 0x95, 0x83, 0xA8, 0xE9, 0x87, 0xB8, 0xFA, 0x80, 0xB6, 0xF8, 0x7F, 0xB6, 0xF9, 0x7E, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x82, 0xB6, 0xFA, 0x82, 0xB6, 0xFB, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x80, 0xB6, 0xFA, 0x81, 0xB7, 0xF9, 0x80, 0xB6, 0xF9, 0x80, 0xB6, 0xFB, 0x80, 0xB6, 0xFC, 0x80, 0xB6, 0xFA, 0x80, 0xB5, 0xF9, 0x81, 0xB5, 0xF8, 0x81, 0xB6, 0xF8, 0x81, 0xB6, 0xF9, 0x80, 0xB6, 0xFA, 0x7F, 0xB7, 0xF9, 0x80, 0xB6, 0xF8, 0x84, 0xB9, 0xF9, 0x88, 0xB7, 0xF0, 0x9C, 0xB7, 0xD7, 0xE2, 0xE8, 0xEA, 0xFF, 0xFF, 0xFF, 0xDA, 0xDC, 0xE6, 0x97, 0x96, 0xA4, 0x89, 0x87, 0x7F, 0x81, 0x84, 0x73, 0x84, 0x87, 0x7F, 0x90, 0x8F, 0x8E, 0x7E, 0x80, 0x92, 0x81, 0x91, 0xB7, 0x78, 0x93, 0xBE, 0x83, 0xA9, 0xDF, 0x85, 0xB0, 0xE5, 0x8D, 0xA9, 0xD7, 0x73, 0x7D, 0x8A, 0x6B, 0x6F, 0x67, 0x53, 0x58, 0x51, 0x5B, 0x6B, 0x7E, 0x9B, 0xC4, 0xFF, 0x5E, 0x84, 0xAB, 0x19, 0x1E, 0x31, 0x27, 0x25, 0x30, 0x1E, 0x1A, 0x29, 0x60, 0x60, 0x74, 0x9B, 0xA5, 0xB7, 0x99, 0xA2, 0xAD, 0x77, 0x84, 0x84, 0x3F, 0x4D, 0x4A, 0x37, 0x37, 0x48, 0x5F, 0x70, 0x9D, 0x47, 0x5E, 0x90, 0x43, 0x4D, 0x6E, 0x94, 0x81, 0x8C, 0xFF, 0xF5, 0xF5, 0xEB, 0xFF, 0xFF, 0x50, 0x73, 0x81, 0x42, 0x57, 0x89, 0x83, 0xA4, 0xEA, 0x85, 0xB9, 0xFB, 0x7F, 0xB7, 0xF7, 0x7E, 0xB7, 0xF7, 0x7D, 0xB7, 0xF9, 0x7C, 0xB6, 0xF9, 0x7E, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x82, 0xB7, 0xFA, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x80, 0xB5, 0xF9, 0x81, 0xB6, 0xF9, 0x7F, 0xB6, 0xF9, 0x7E, 0xB5, 0xF9, 0x7E, 0xB5, 0xFB, 0x7F, 0xB6, 0xF9, 0x80, 0xB6, 0xF9, 0x81, 0xB6, 0xF9, 0x80, 0xB6, 0xFA, 0x80, 0xB5, 0xFA, 0x81, 0xB6, 0xFA, 0x83, 0xB7, 0xF9, 0x80, 0xB7, 0xF9, 0x81, 0xB7, 0xFC, 0x83, 0xB8, 0xFF, 0x88, 0xB5, 0xEA, 0xA1, 0xBA, 0xD1, 0xEA, 0xF2, 0xF5, 0xFF, 0xFF, 0xFF, 0xC7, 0xC4, 0xCC, 0x87, 0x7F, 0x85, 0x89, 0x87, 0x7A, 0x7F, 0x80, 0x6D, 0x95, 0x92, 0x8F, 0x9A, 0x9B, 0xA5, 0x6C, 0x75, 0x8C, 0x80, 0x8C, 0xAC, 0x76, 0x89, 0xB2, 0x71, 0x8A, 0xB4, 0x7D, 0x91, 0xB9, 0x70, 0x7D, 0x8B, 0x66, 0x6C, 0x65, 0x5B, 0x60, 0x5D, 0x4B, 0x58, 0x67, 0x4E, 0x71, 0xAC, 0x3C, 0x59, 0x7F, 0x45, 0x46, 0x59, 0x51, 0x4F, 0x57, 0x41, 0x3B, 0x48, 0x6D, 0x6A, 0x7A, 0xA7, 0xB3, 0xBB, 0x8E, 0x99, 0xA2, 0x5C, 0x66, 0x6B, 0x2E, 0x3A, 0x3D, 0x59, 0x66, 0x7E, 0x79, 0x91, 0xC5, 0x71, 0x68, 0x92, 0x61, 0x45, 0x57, 0xB6, 0xA7, 0xA6, 0xFF, 0xFF, 0xFF, 0x9F, 0xC1, 0xC8, 0x3D, 0x5C, 0x88, 0x7E, 0x9A, 0xDF, 0x88, 0xBC, 0xFE, 0x7E, 0xB8, 0xF8, 0x80, 0xB5, 0xF8, 0x7F, 0xB7, 0xF9, 0x7C, 0xB7, 0xF9, 0x7D, 0xB8, 0xFB, 0x7D, 0xB7, 0xFA, 0x7F, 0xB6, 0xF9, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x82, 0xB7, 0xFB, 0x81, 0xB6, 0xFA, 0x81, 0xB5, 0xF9, 0x7E, 0xB6, 0xF9, 0x7D, 0xB6, 0xFA, 0x7C, 0xB5, 0xFA, 0x7E, 0xB6, 0xF9, 0x7F, 0xB7, 0xFA, 0x82, 0xB7, 0xF9, 0x7E, 0xB6, 0xF9, 0x7E, 0xB6, 0xFA, 0x83, 0xB7, 0xF8, 0x85, 0xB7, 0xF9, 0x81, 0xB7, 0xF9, 0x82, 0xB6, 0xFD, 0x83, 0xB7, 0xFA, 0x84, 0xB9, 0xF8, 0x8B, 0xB6, 0xE9, 0xA6, 0xC0, 0xD5, 0xEE, 0xF6, 0xF7, 0xFE, 0xFD, 0xFE, 0xC4, 0xBB, 0xC4, 0x8E, 0x85, 0x81, 0x89, 0x86, 0x72, 0x85, 0x81, 0x76, 0x96, 0x99, 0x98, 0x8C, 0x92, 0x9B, 0xA2, 0xA9, 0xBA, 0xA0, 0xAB, 0xCA, 0xA7, 0xB8, 0xDF, 0xAB, 0xBA, 0xE3, 0x79, 0x84, 0x95, 0x6B, 0x6F, 0x69, 0x61, 0x65, 0x64, 0x4D, 0x54, 0x62, 0x65, 0x83, 0xB3, 0x38, 0x50, 0x73, 0x65, 0x65, 0x70, 0x7D, 0x7F, 0x7F, 0x80, 0x79, 0x83, 0x95, 0x92, 0xA0, 0xA7, 0xB7, 0xB9, 0x6F, 0x7E, 0x84, 0x3E, 0x47, 0x4D, 0x31, 0x39, 0x3F, 0x67, 0x77, 0x8E, 0x78, 0x87, 0xAF, 0x97, 0x7B, 0x8C, 0xDF, 0xCC, 0xD3, 0xBA, 0xC4, 0xC7, 0xA8, 0xC5, 0xCA, 0x52, 0x77, 0x97, 0x74, 0x98, 0xD8, 0x8D, 0xB9, 0xFF, 0x7E, 0xB8, 0xF5, 0x7E, 0xB6, 0xF8, 0x81, 0xB4, 0xFB, 0x80, 0xB7, 0xF9, 0x7D, 0xB6, 0xFA, 0x7D, 0xB8, 0xFD, 0x7E, 0xB7, 0xFA, 0x80, 0xB7, 0xF9, 0x81, 0xB7, 0xFA, 0x81, 0xB8, 0xFB, 0x80, 0xB8, 0xFA, 0x7F, 0xB6, 0xF9, 0x81, 0xB6, 0xFA, 0x7D, 0xB6, 0xF9, 0x7E, 0xB6, 0xFA, 0x7D, 0xB6, 0xFB, 0x7D, 0xB6, 0xF9, 0x7E, 0xB7, 0xFA, 0x80, 0xB7, 0xF9, 0x7D, 0xB6, 0xFA, 0x7F, 0xB7, 0xFB, 0x83, 0xB5, 0xF7, 0x85, 0xB6, 0xF6, 0x82, 0xB7, 0xF9, 0x81, 0xB7, 0xF8, 0x84, 0xB7, 0xF8, 0x83, 0xB7, 0xF7, 0x85, 0xBA, 0xF7, 0x8B, 0xB2, 0xE2, 0xAD, 0xC2, 0xD4, 0xF2, 0xF9, 0xFA, 0xFF, 0xFC, 0xFD, 0xBE, 0xB2, 0xB6, 0x90, 0x8A, 0x80, 0x8A, 0x86, 0x71, 0x84, 0x8A, 0x7E, 0x76, 0x81, 0x80, 0x3E, 0x48, 0x4F, 0x45, 0x53, 0x72, 0x6C, 0x7F, 0xAB, 0x70, 0x7F, 0xAE, 0x78, 0x7F, 0x94, 0x72, 0x76, 0x6D, 0x63, 0x68, 0x61, 0x51, 0x56, 0x5E, 0x82, 0x9D, 0xBE, 0x3D, 0x50, 0x70, 0x25, 0x25, 0x28, 0x2B, 0x2C, 0x27, 0x4E, 0x46, 0x50, 0x9A, 0x9A, 0xA5, 0x84, 0x98, 0x94, 0x4E, 0x60, 0x60, 0x33, 0x3C, 0x40, 0x35, 0x3B, 0x46, 0x31, 0x36, 0x44, 0x49, 0x45, 0x56, 0xDF, 0xD3, 0xD3, 0xFF, 0xFF, 0xFF, 0x6F, 0x89, 0x93, 0x34, 0x4F, 0x72, 0x6D, 0x94, 0xCA, 0x8A, 0xBA, 0xFD, 0x7E, 0xB6, 0xF8, 0x7F, 0xB7, 0xF5, 0x80, 0xB5, 0xFA, 0x81, 0xB4, 0xFB, 0x81, 0xB5, 0xFA, 0x7F, 0xB7, 0xFC, 0x7E, 0xB7, 0xFC, 0x7E, 0xB7, 0xFB, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFB, 0x80, 0xB7, 0xFC, 0x7F, 0xB6, 0xFB, 0x7F, 0xB6, 0xFB, 0x81, 0xB6, 0xFC, 0x80, 0xB7, 0xFA, 0x81, 0xB7, 0xFA, 0x80, 0xB5, 0xF9, 0x80, 0xB5, 0xF9, 0x7F, 0xB6, 0xF9, 0x80, 0xB6, 0xFA, 0x80, 0xB5, 0xF9, 0x82, 0xB6, 0xFA, 0x82, 0xB6, 0xFA, 0x82, 0xB7, 0xFB, 0x80, 0xB7, 0xF9, 0x81, 0xB7, 0xF9, 0x83, 0xB6, 0xF8, 0x83, 0xB7, 0xF9, 0x81, 0xB8, 0xFA, 0x87, 0xB9, 0xF2, 0x8F, 0xB3, 0xDD, 0xB6, 0xC6, 0xDD, 0xF6, 0xFA, 0xF7, 0xFA, 0xF8, 0xF8, 0xAE, 0xA8, 0xB0, 0x90, 0x88, 0x78, 0x7F, 0x86, 0x6A, 0x71, 0x7D, 0x76, 0x61, 0x63, 0x6B, 0x3E, 0x39, 0x4D, 0x67, 0x6C, 0x8C, 0x8A, 0x93, 0xBC, 0x7D, 0x7E, 0x94, 0x6B, 0x6D, 0x69, 0x68, 0x66, 0x60, 0x50, 0x55, 0x53, 0x46, 0x53, 0x62, 0x30, 0x31, 0x47, 0x46, 0x3F, 0x44, 0x5D, 0x53, 0x54, 0x6A, 0x63, 0x6D, 0x8A, 0x92, 0x93, 0x70, 0x80, 0x7F, 0x40, 0x4D, 0x50, 0x34, 0x38, 0x40, 0x33, 0x31, 0x45, 0x3B, 0x3B, 0x4B, 0x51, 0x4C, 0x53, 0xCD, 0xD6, 0xD3, 0xB4, 0xC8, 0xCD, 0x36, 0x51, 0x72, 0x61, 0x82, 0xBD, 0x8B, 0xBA, 0xFA, 0x84, 0xB7, 0xF7, 0x80, 0xB7, 0xF8, 0x81, 0xB6, 0xF8, 0x82, 0xB6, 0xF8, 0x81, 0xB5, 0xF8, 0x81, 0xB5, 0xFA, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xFC, 0x82, 0xB7, 0xFD, 0x7F, 0xB7, 0xFC, 0x7D, 0xB7, 0xFC, 0x7C, 0xB6, 0xF9, 0x80, 0xB6, 0xFA, 0x82, 0xB7, 0xFB, 0x80, 0xB7, 0xFA, 0x80, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xF9, 0x81, 0xB7, 0xFA, 0x81, 0xB7, 0xFA, 0x82, 0xB7, 0xFB, 0x81, 0xB7, 0xFB, 0x81, 0xB7, 0xFB, 0x80, 0xB7, 0xF9, 0x7F, 0xB7, 0xF8, 0x81, 0xB7, 0xF7, 0x81, 0xB7, 0xF7, 0x7F, 0xB8, 0xFC, 0x83, 0xB8, 0xF9, 0x8B, 0xB9, 0xF0, 0x95, 0xB1, 0xDD, 0xC3, 0xD4, 0xDF, 0xFE, 0xFF, 0xFF, 0xEB, 0xEB, 0xEC, 0x95, 0x98, 0x8D, 0x7F, 0x87, 0x6E, 0x6C, 0x70, 0x64, 0x77, 0x70, 0x75, 0x87, 0x7A, 0x87, 0xB8, 0xB4, 0xC5, 0xD7, 0xDA, 0xEF, 0xAB, 0xA7, 0xB2, 0x70, 0x5C, 0x5D, 0x68, 0x55, 0x53, 0x54, 0x4F, 0x4F, 0x4C, 0x47, 0x51, 0x58, 0x48, 0x57, 0x6E, 0x66, 0x6B, 0x8C, 0x8A, 0x89, 0x87, 0x88, 0x8E, 0x74, 0x7F, 0x7F, 0x59, 0x69, 0x69, 0x34, 0x42, 0x42, 0x38, 0x3D, 0x3E, 0x2D, 0x2F, 0x3D, 0x3D, 0x3E, 0x4D, 0x48, 0x4A, 0x56, 0x47, 0x53, 0x61, 0x3B, 0x45, 0x66, 0x5B, 0x78, 0xAB, 0x8B, 0xB8, 0xF5, 0x85, 0xB7, 0xF7, 0x81, 0xB6, 0xF7, 0x81, 0xB8, 0xF9, 0x82, 0xB7, 0xFA, 0x82, 0xB7, 0xFA, 0x82, 0xB6, 0xFA, 0x81, 0xB7, 0xFB, 0x81, 0xB7, 0xFA, 0x81, 0xB7, 0xFA, 0x81, 0xB7, 0xFC, 0x81, 0xB6, 0xFC, 0x80, 0xB6, 0xFD, 0x7F, 0xB7, 0xFC, 0x7E, 0xB6, 0xF9, 0x81, 0xB7, 0xFA, 0x82, 0xB7, 0xFB, 0x80, 0xB7, 0xF9, 0x80, 0xB7, 0xFA, 0x81, 0xB7, 0xFA, 0x80, 0xB5, 0xF9, 0x81, 0xB6, 0xF8, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x81, 0xB8, 0xFB, 0x80, 0xB7, 0xFA, 0x7F, 0xB6, 0xF9, 0x7E, 0xB7, 0xF9, 0x7D, 0xB6, 0xF8, 0x7F, 0xB6, 0xF7, 0x81, 0xB7, 0xF7, 0x80, 0xB7, 0xFB, 0x7F, 0xB8, 0xFC, 0x81, 0xB7, 0xF8, 0x8C, 0xB7, 0xF5, 0x95, 0xB8, 0xDE, 0xC0, 0xD2, 0xDC, 0xF4, 0xFF, 0xFE, 0xBD, 0xCE, 0xC7, 0x6C, 0x74, 0x68, 0x5F, 0x5C, 0x55, 0x76, 0x6A, 0x6F, 0x94, 0x84, 0x8F, 0xAD, 0xA6, 0xAC, 0xA0, 0x9E, 0xA0, 0xA6, 0x9C, 0x9F, 0x88, 0x71, 0x72, 0x6F, 0x5A, 0x5C, 0x54, 0x47, 0x4C, 0x58, 0x4E, 0x53, 0x6C, 0x61, 0x66, 0x68, 0x66, 0x6A, 0x72, 0x73, 0x77, 0x58, 0x5A, 0x65, 0x4F, 0x57, 0x61, 0x3B, 0x44, 0x4D, 0x2B, 0x30, 0x36, 0x76, 0x74, 0x77, 0x5F, 0x5C, 0x68, 0x46, 0x4B, 0x57, 0x4A, 0x50, 0x65, 0x34, 0x3B, 0x64, 0x56, 0x6C, 0xA6, 0x8A, 0xB3, 0xF5, 0x86, 0xB9, 0xFA, 0x81, 0xB6, 0xF7, 0x80, 0xB6, 0xF8, 0x81, 0xB8, 0xFA, 0x81, 0xB7, 0xFB, 0x82, 0xB6, 0xFA, 0x81, 0xB5, 0xFB, 0x7F, 0xB6, 0xFB, 0x7F, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x80, 0xB6, 0xFC, 0x82, 0xB8, 0xFE, 0x7F, 0xB7, 0xFC, 0x7F, 0xB7, 0xFA, 0x81, 0xB6, 0xFA, 0x82, 0xB6, 0xFB, 0x80, 0xB7, 0xF9, 0x7F, 0xB6, 0xF9, 0x80, 0xB7, 0xFA, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xF9, 0x81, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x7E, 0xB8, 0xF9, 0x7F, 0xB7, 0xFB, 0x80, 0xB6, 0xFA, 0x83, 0xB6, 0xF8, 0x82, 0xB7, 0xF8, 0x81, 0xB8, 0xF9, 0x7F, 0xB8, 0xF8, 0x81, 0xB8, 0xFA, 0x88, 0xB8, 0xF5, 0x8D, 0xB0, 0xD7, 0xAF, 0xCA, 0xD7, 0x9C, 0xB7, 0xBA, 0x3F, 0x47, 0x4C, 0x48, 0x47, 0x4C, 0x6C, 0x67, 0x6E, 0x85, 0x7E, 0x88, 0xA2, 0xA0, 0xA5, 0xC2, 0xC3, 0xC1, 0xDF, 0xDB, 0xDC, 0xF0, 0xEA, 0xEB, 0xE7, 0xE5, 0xE6, 0xA4, 0xA5, 0xA8, 0x94, 0x91, 0x94, 0xAD, 0xAE, 0xAF, 0x7F, 0x8A, 0x8E, 0x4A, 0x53, 0x5C, 0x46, 0x4D, 0x5E, 0x39, 0x42, 0x53, 0x2D, 0x36, 0x49, 0x2A, 0x30, 0x3F, 0x66, 0x68, 0x72, 0x55, 0x54, 0x63, 0x3A, 0x39, 0x4E, 0x32, 0x37, 0x5C, 0x51, 0x63, 0x9C, 0x88, 0xB2, 0xF6, 0x86, 0xB8, 0xFE, 0x81, 0xB7, 0xFA, 0x80, 0xB7, 0xF9, 0x80, 0xB7, 0xF9, 0x82, 0xB7, 0xFB, 0x82, 0xB7, 0xFB, 0x81, 0xB6, 0xFA, 0x80, 0xB5, 0xFB, 0x80, 0xB6, 0xFC, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x82, 0xB8, 0xFD, 0x82, 0xB7, 0xFD, 0x7F, 0xB6, 0xFA, 0x7F, 0xB7, 0xFA, 0x81, 0xB6, 0xFA, 0x82, 0xB7, 0xFB, 0x7F, 0xB6, 0xF9, 0x7E, 0xB6, 0xFA, 0x7E, 0xB6, 0xFA, 0x7F, 0xB6, 0xFA, 0x81, 0xB7, 0xFA, 0x81, 0xB7, 0xFB, 0x80, 0xB6, 0xF9, 0x81, 0xB6, 0xFA, 0x82, 0xB7, 0xFB, 0x81, 0xB6, 0xFA, 0x7F, 0xB6, 0xF8, 0x80, 0xB7, 0xFA, 0x7F, 0xB8, 0xFB, 0x80, 0xB7, 0xFA, 0x81, 0xB6, 0xF7, 0x80, 0xB7, 0xF7, 0x7F, 0xB9, 0xF8, 0x80, 0xB9, 0xFA, 0x81, 0xB8, 0xFA, 0x86, 0xB9, 0xF3, 0x79, 0xA4, 0xCC, 0x46, 0x63, 0x78, 0x66, 0x70, 0x7D, 0xA4, 0xAC, 0xB6, 0xBB, 0xC3, 0xC8, 0xC4, 0xCA, 0xD0, 0xC8, 0xCF, 0xD7, 0xCD, 0xD9, 0xD8, 0xE1, 0xE7, 0xE6, 0xEA, 0xEE, 0xEF, 0xD9, 0xE4, 0xE2, 0x9D, 0xA8, 0xA8, 0xA6, 0xA5, 0xAA, 0xC6, 0xCB, 0xD1, 0x92, 0xA7, 0xAB, 0x64, 0x76, 0x7C, 0x71, 0x7F, 0x8F, 0x64, 0x74, 0x83, 0x55, 0x65, 0x77, 0x49, 0x58, 0x68, 0x38, 0x47, 0x55, 0x33, 0x3D, 0x52, 0x36, 0x36, 0x59, 0x58, 0x6C, 0xA0, 0x85, 0xB0, 0xED, 0x84, 0xBA, 0xFB, 0x81, 0xB5, 0xFA, 0x7E, 0xB8, 0xFC, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x81, 0xB6, 0xF9, 0x81, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x7F, 0xB7, 0xFC, 0x80, 0xB8, 0xFD, 0x80, 0xB8, 0xFC, 0x7F, 0xB7, 0xF9, 0x80, 0xB8, 0xFB, 0x81, 0xB9, 0xFC, 0x81, 0xB7, 0xFC, 0x81, 0xB8, 0xFB, 0x80, 0xB7, 0xFA, 0x80, 0xB6, 0xF8, 0x81, 0xB6, 0xF8, 0x7F, 0xB6, 0xFC, 0x7D, 0xB6, 0xFC, 0x7E, 0xB7, 0xFC, 0x7E, 0xB6, 0xFC, 0x81, 0xB7, 0xFB, 0x82, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x83, 0xB7, 0xFB, 0x83, 0xB7, 0xFC, 0x81, 0xB6, 0xFA, 0x80, 0xB6, 0xF9, 0x7E, 0xB7, 0xF7, 0x7D, 0xB7, 0xF9, 0x7E, 0xB8, 0xFC, 0x7F, 0xB8, 0xFB, 0x80, 0xB8, 0xF8, 0x7E, 0xB8, 0xF9, 0x81, 0xB9, 0xFA, 0x80, 0xB7, 0xF7, 0x7D, 0xB9, 0xF7, 0x88, 0xBD, 0xF9, 0x6B, 0x85, 0xAD, 0x61, 0x6F, 0x7C, 0x5D, 0x6D, 0x74, 0x45, 0x54, 0x54, 0x30, 0x3F, 0x3F, 0x25, 0x34, 0x3C, 0x23, 0x32, 0x33, 0x2F, 0x3C, 0x3A, 0x3D, 0x4B, 0x49, 0x38, 0x43, 0x3F, 0x38, 0x35, 0x37, 0x8D, 0x88, 0x8F, 0x71, 0x7D, 0x85, 0x27, 0x3B, 0x41, 0x24, 0x30, 0x35, 0x26, 0x33, 0x3D, 0x2E, 0x3C, 0x45, 0x33, 0x43, 0x4F, 0x33, 0x43, 0x52, 0x38, 0x4A, 0x58, 0x4B, 0x52, 0x6E, 0x70, 0x7E, 0xAC, 0x8B, 0xB6, 0xF2, 0x85, 0xB9, 0xFA, 0x7C, 0xB8, 0xF7, 0x80, 0xB6, 0xF8, 0x7D, 0xB7, 0xFB, 0x7F, 0xB6, 0xFA, 0x81, 0xB6, 0xF9, 0x81, 0xB6, 0xF8, 0x81, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x7E, 0xB7, 0xFB, 0x7E, 0xB8, 0xFC, 0x7E, 0xB8, 0xFB, 0x7E, 0xB7, 0xF9, 0x7E, 0xB7, 0xFA, 0x7F, 0xB8, 0xFB, 0x81, 0xB8, 0xFC, 0x82, 0xB8, 0xFC, 0x80, 0xB7, 0xFA, 0x82, 0xB7, 0xF9, 0x81, 0xB6, 0xF8, 0x80, 0xB7, 0xFB, 0x80, 0xB6, 0xFC, 0x7F, 0xB7, 0xFC, 0x80, 0xB7, 0xFC, 0x81, 0xB7, 0xFB, 0x81, 0xB6, 0xFA, 0x81, 0xB6, 0xFA, 0x82, 0xB7, 0xF9, 0x83, 0xB7, 0xFA, 0x81, 0xB7, 0xFA, 0x80, 0xB7, 0xFB, 0x7F, 0xB6, 0xFB, 0x80, 0xB6, 0xFB, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x82, 0xB7, 0xF9, 0x81, 0xB6, 0xF8, 0x81, 0xB8, 0xF8, 0x83, 0xB4, 0xFD, 0x81, 0xB8, 0xFD, 0x7D, 0xB5, 0xF3, 0x44, 0x62, 0x97, 0x24, 0x35, 0x49, 0x1B, 0x24, 0x2D, 0x15, 0x1D, 0x26, 0x14, 0x1C, 0x27, 0x18, 0x1D, 0x27, 0x1E, 0x21, 0x2A, 0x22, 0x27, 0x32, 0x23, 0x2B, 0x2F, 0x2B, 0x29, 0x2F, 0x42, 0x31, 0x3C, 0xC0, 0xB8, 0xBD, 0xA0, 0xA1, 0xAC, 0x39, 0x44, 0x4F, 0x1D, 0x21, 0x28, 0x16, 0x1C, 0x24, 0x12, 0x1B, 0x21, 0x14, 0x1B, 0x22, 0x18, 0x1E, 0x2C, 0x23, 0x24, 0x37, 0x2A, 0x29, 0x47, 0x52, 0x66, 0x9D, 0x7F, 0xB1, 0xEF, 0x7E, 0xBA, 0xFB, 0x7E, 0xB6, 0xFB, 0x7F, 0xB6, 0xF8, 0x7D, 0xB7, 0xF9, 0x7E, 0xB7, 0xF9, 0x80, 0xB7, 0xFA, 0x80, 0xB8, 0xFB, 0x7F, 0xB8, 0xFB, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x7E, 0xB7, 0xF9, 0x7D, 0xB9, 0xF8, 0x7F, 0xB8, 0xF9, 0x81, 0xB8, 0xFB, 0x80, 0xB7, 0xFB, 0x7E, 0xB7, 0xFB, 0x80, 0xB7, 0xFA, 0x81, 0xB5, 0xF9, 0x84, 0xB7, 0xF8, 0x82, 0xB6, 0xF8, 0x7F, 0xB6, 0xFB, 0x80, 0xB6, 0xFC, 0x80, 0xB7, 0xFC, 0x81, 0xB8, 0xFA, 0x82, 0xB8, 0xF9, 0x82, 0xB7, 0xF9, 0x81, 0xB6, 0xF9, 0x82, 0xB7, 0xFB, 0x82, 0xB7, 0xFC, 0x81, 0xB6, 0xFA, 0x80, 0xB6, 0xF9, 0x80, 0xB6, 0xF9, 0x81, 0xB6, 0xFA, 0x81, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x81, 0xB7, 0xFA, 0x81, 0xB7, 0xFA, 0x83, 0xB6, 0xFA, 0x82, 0xB8, 0xF8, 0x80, 0xB7, 0xF7, 0x87, 0xB8, 0xF7, 0x67, 0x83, 0xC5, 0x2E, 0x36, 0x5D, 0x20, 0x23, 0x39, 0x1B, 0x1E, 0x38, 0x1F, 0x1F, 0x41, 0x25, 0x1F, 0x42, 0x23, 0x1C, 0x3E, 0x1E, 0x1B, 0x3B, 0x1C, 0x1B, 0x37, 0x1C, 0x12, 0x30, 0x58, 0x46, 0x5B, 0xE7, 0xE2, 0xE7, 0xF2, 0xF4, 0xFA, 0x9B, 0xA8, 0xB3, 0x1E, 0x1F, 0x30, 0x22, 0x1E, 0x3A, 0x22, 0x1E, 0x3C, 0x1B, 0x1B, 0x2E, 0x19, 0x1C, 0x2B, 0x1F, 0x1D, 0x38, 0x2A, 0x29, 0x55, 0x46, 0x5A, 0x9D, 0x78, 0xAC, 0xED, 0x7D, 0xBC, 0xF9, 0x7F, 0xB7, 0xF9, 0x82, 0xB4, 0xF9, 0x7E, 0xB5, 0xF9, 0x80, 0xB7, 0xFA, 0x82, 0xB7, 0xFB, 0x80, 0xB7, 0xFB, 0x81, 0xB8, 0xFB, 0x81, 0xB7, 0xFA, 0x81, 0xB7, 0xFA, 0x80, 0xB9, 0xF9, 0x7F, 0xB9, 0xF9, 0x80, 0xB7, 0xF8, 0x83, 0xB8, 0xFB, 0x81, 0xB7, 0xFB, 0x7F, 0xB8, 0xFA, 0x80, 0xB8, 0xFB, 0x82, 0xB7, 0xFB, 0x82, 0xB7, 0xF9, 0x81, 0xB6, 0xF8, 0x80, 0xB6, 0xFD, 0x81, 0xB8, 0xFD, 0x81, 0xB8, 0xFB, 0x80, 0xB7, 0xF8, 0x80, 0xB6, 0xF8, 0x82, 0xB7, 0xF8, 0x82, 0xB7, 0xF9, 0x82, 0xB7, 0xFC, 0x82, 0xB7, 0xFD, 0x81, 0xB6, 0xFB, 0x82, 0xB7, 0xF8, 0x83, 0xB7, 0xFA, 0x82, 0xB7, 0xFB, 0x82, 0xB7, 0xFB, 0x81, 0xB8, 0xFB, 0x81, 0xB8, 0xFB, 0x80, 0xB7, 0xFA, 0x81, 0xB6, 0xFB, 0x81, 0xBA, 0xF5, 0x8A, 0xB7, 0xF4, 0x97, 0xB0, 0xE6, 0x9D, 0xB2, 0xEA, 0x5B, 0x60, 0x89, 0x41, 0x41, 0x69, 0x53, 0x58, 0x8C, 0x47, 0x4E, 0x8C, 0x3F, 0x46, 0x87, 0x3E, 0x44, 0x82, 0x34, 0x3A, 0x76, 0x2D, 0x33, 0x6F, 0x32, 0x34, 0x6A, 0x74, 0x70, 0x93, 0xE0, 0xE6, 0xED, 0xE8, 0xF4, 0xF4, 0x95, 0xA8, 0xB4, 0x1E, 0x24, 0x45, 0x23, 0x22, 0x54, 0x1F, 0x21, 0x59, 0x1F, 0x22, 0x4B, 0x20, 0x20, 0x3A, 0x2E, 0x2F, 0x56, 0x65, 0x75, 0xAE, 0x8C, 0xAF, 0xF7, 0x80, 0xB7, 0xFA, 0x7C, 0xB9, 0xF6, 0x81, 0xB9, 0xF9, 0x84, 0xB6, 0xFA, 0x80, 0xB5, 0xF9, 0x80, 0xB7, 0xFA, 0x82, 0xB7, 0xFB, 0x81, 0xB8, 0xFB, 0x81, 0xB8, 0xFB, 0x83, 0xB7, 0xFB, 0x83, 0xB7, 0xFA, 0x81, 0xB9, 0xF9, 0x80, 0xB9, 0xF9, 0x82, 0xB7, 0xF9, 0x83, 0xB7, 0xF9, 0x84, 0xB8, 0xFB, 0x81, 0xB8, 0xFC, 0x80, 0xB7, 0xFB, 0x82, 0xB7, 0xFB, 0x82, 0xB7, 0xFB, 0x81, 0xB6, 0xFA, 0x82, 0xB7, 0xFC, 0x82, 0xB8, 0xFB, 0x82, 0xB7, 0xFA, 0x82, 0xB6, 0xF8, 0x81, 0xB7, 0xF9, 0x82, 0xB8, 0xF8, 0x81, 0xB8, 0xF9, 0x80, 0xB7, 0xFB, 0x81, 0xB7, 0xFD, 0x81, 0xB7, 0xFC, 0x83, 0xB7, 0xF9, 0x85, 0xB7, 0xFB, 0x82, 0xB7, 0xFB, 0x80, 0xB7, 0xFB, 0x80, 0xB8, 0xFB, 0x81, 0xB8, 0xFA, 0x81, 0xB7, 0xFA, 0x7F, 0xB8, 0xFB, 0x82, 0xB8, 0xF7, 0x9A, 0xB4, 0xF3, 0xC1, 0xC3, 0xE4, 0xB7, 0xC6, 0xDC, 0x8C, 0x92, 0xA8, 0x59, 0x5D, 0x86, 0x9A, 0xA9, 0xE3, 0x9A, 0xBB, 0xFB, 0x8F, 0xB9, 0xFD, 0x92, 0xB9, 0xFD, 0x96, 0xB6, 0xF9, 0x93, 0xB4, 0xFA, 0x93, 0xB3, 0xF5, 0xA6, 0xB9, 0xE9, 0xC0, 0xD5, 0xE3, 0xD4, 0xE6, 0xE8, 0x75, 0x8C, 0xA1, 0x57, 0x65, 0x93, 0x88, 0x97, 0xCF, 0x78, 0x90, 0xCD, 0x68, 0x7B, 0xB4, 0x29, 0x2D, 0x58, 0x51, 0x5A, 0x89, 0x9B, 0xC3, 0xF7, 0x87, 0xBB, 0xFF, 0x7F, 0xB6, 0xFC, 0x80, 0xB8, 0xF7, 0x82, 0xB7, 0xF8, 0x81, 0xB7, 0xF9, 0x81, 0xB7, 0xFA, 0x82, 0xB7, 0xF9, 0x81, 0xB6, 0xF9, 0x81, 0xB8, 0xFB, 0x80, 0xB7, 0xFA, 0x83, 0xB7, 0xFC, 0x85, 0xB8, 0xFD, 0x81, 0xB8, 0xFA, 0x81, 0xB8, 0xF9, 0x83, 0xB8, 0xF9, 0x84, 0xB7, 0xF9, 0x84, 0xB8, 0xF9, 0x81, 0xB7, 0xFB, 0x81, 0xB8, 0xFC, 0x81, 0xB8, 0xFB, 0x81, 0xB8, 0xFB, 0x81, 0xB8, 0xFB, 0x81, 0xB6, 0xFA, 0x82, 0xB7, 0xF9, 0x81, 0xB6, 0xF8, 0x83, 0xB8, 0xFA, 0x82, 0xB7, 0xFC, 0x80, 0xB8, 0xFA, 0x7F, 0xB8, 0xF9, 0x7E, 0xB8, 0xF9, 0x7F, 0xB8, 0xFC, 0x81, 0xB8, 0xFB, 0x84, 0xB7, 0xFB, 0x84, 0xB7, 0xFB, 0x81, 0xB7, 0xFC, 0x7E, 0xB7, 0xFA, 0x7D, 0xB7, 0xF9, 0x80, 0xB9, 0xF9, 0x82, 0xB8, 0xF9, 0x81, 0xB9, 0xFC, 0x87, 0xB5, 0xF9, 0xA0, 0xB4, 0xE9, 0xF2, 0xEE, 0xFC, 0xD7, 0xE3, 0xE6, 0xB1, 0xB8, 0xC0, 0x71, 0x7E, 0xA2, 0x87, 0xA2, 0xD5, 0x89, 0xB8, 0xF1, 0x80, 0xB9, 0xF6, 0x81, 0xB9, 0xF6, 0x83, 0xB8, 0xF5, 0x81, 0xB8, 0xF9, 0x86, 0xB9, 0xFA, 0x98, 0xB5, 0xEB, 0x85, 0x9A, 0xB3, 0x8F, 0x9F, 0xA5, 0x58, 0x6D, 0x89, 0x68, 0x7B, 0xAB, 0xAA, 0xBE, 0xE7, 0x93, 0xB1, 0xDF, 0x60, 0x7E, 0xBD, 0x31, 0x3E, 0x75, 0x41, 0x50, 0x7A, 0x6A, 0x94, 0xB9, 0x71, 0xA2, 0xDE, 0x82, 0xB4, 0xF9, 0x81, 0xB7, 0xF9, 0x80, 0xB7, 0xFA, 0x7F, 0xB8, 0xF9, 0x7F, 0xB8, 0xF9, 0x82, 0xB7, 0xF9, 0x82, 0xB8, 0xF8, 0x80, 0xB8, 0xFA, 0x7F, 0xB8, 0xFB, 0x83, 0xB7, 0xFB, 0x84, 0xB8, 0xFC, 0x82, 0xB8, 0xFB, 0x7F, 0xB8, 0xF9, 0x83, 0xB8, 0xF9, 0x84, 0xB7, 0xF9, 0x84, 0xB8, 0xF9, 0x81, 0xB7, 0xFC, 0x81, 0xB7, 0xFD, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x81, 0xB8, 0xFB, 0x81, 0xB6, 0xF8, 0x84, 0xB8, 0xFA, 0x84, 0xB8, 0xFA, 0x83, 0xB7, 0xFC, 0x81, 0xB6, 0xFC, 0x7F, 0xB6, 0xFB, 0x7E, 0xB7, 0xF9, 0x7D, 0xB9, 0xF8, 0x7F, 0xB9, 0xFA, 0x80, 0xB7, 0xFA, 0x82, 0xB6, 0xFB, 0x82, 0xB7, 0xFE, 0x81, 0xB7, 0xFD, 0x7E, 0xB7, 0xFB, 0x7D, 0xB8, 0xF8, 0x80, 0xBA, 0xF9, 0x83, 0xB7, 0xF8, 0x82, 0xB7, 0xFC, 0x8B, 0xB2, 0xF8, 0xA5, 0xBC, 0xDF, 0xF1, 0xF5, 0xFD, 0xCE, 0xDC, 0xE0, 0xAD, 0xB3, 0xBD, 0x85, 0x97, 0xBF, 0x8C, 0xAB, 0xE0, 0x89, 0xB2, 0xEE, 0x85, 0xB5, 0xF7, 0x83, 0xB8, 0xF9, 0x82, 0xB8, 0xFB, 0x7B, 0xB6, 0xF4, 0x79, 0xAF, 0xE9, 0x91, 0xAC, 0xE6, 0x94, 0xA0, 0xBF, 0x8F, 0x96, 0x9F, 0x67, 0x78, 0x97, 0x5D, 0x6E, 0x9A, 0xA7, 0xB1, 0xCB, 0x81, 0x91, 0xB1, 0x67, 0x8A, 0xC6, 0x4C, 0x66, 0x9D, 0x1D, 0x2E, 0x4D, 0x21, 0x3A, 0x55, 0x46, 0x68, 0x9F, 0x86, 0xB5, 0xF7, 0x7F, 0xB7, 0xFC, 0x7C, 0xB7, 0xFB, 0x7F, 0xB8, 0xF8, 0x81, 0xB8, 0xF9, 0x82, 0xB7, 0xF9, 0x81, 0xB7, 0xF9, 0x80, 0xB8, 0xF9, 0x7F, 0xB9, 0xFB, 0x84, 0xB8, 0xFC, 0x82, 0xB6, 0xFC, 0x81, 0xB8, 0xFC, 0x80, 0xB9, 0xFC, 0x83, 0xB7, 0xFA, 0x84, 0xB8, 0xFA, 0x84, 0xB7, 0xFB, 0x81, 0xB7, 0xFC, 0x81, 0xB7, 0xFD, 0x81, 0xB8, 0xFB, 0x81, 0xB9, 0xFC, 0x81, 0xB8, 0xFB, 0x80, 0xB7, 0xF8, 0x83, 0xB7, 0xF9, 0x84, 0xB7, 0xFA, 0x82, 0xB7, 0xFB, 0x80, 0xB6, 0xFB, 0x80, 0xB6, 0xFA, 0x81, 0xB7, 0xFA, 0x7F, 0xB7, 0xFA, 0x7E, 0xB7, 0xF9, 0x7D, 0xB8, 0xFA, 0x7D, 0xB8, 0xFA, 0x7F, 0xB8, 0xFD, 0x83, 0xB7, 0xFD, 0x83, 0xB6, 0xFB, 0x7F, 0xB8, 0xF9, 0x7D, 0xB9, 0xF8, 0x7F, 0xB7, 0xF8, 0x7F, 0xBA, 0xF9, 0x8C, 0xB1, 0xF1, 0xAA, 0xB5, 0xD6, 0xD4, 0xE1, 0xE9, 0xAC, 0xBE, 0xC7, 0xA9, 0xB5, 0xC3, 0x81, 0x9D, 0xD1, 0x8F, 0xB6, 0xEF, 0x88, 0xB1, 0xE5, 0x89, 0xB3, 0xF0, 0x83, 0xB7, 0xF9, 0x83, 0xB8, 0xFC, 0x81, 0xB5, 0xF7, 0x80, 0xB3, 0xF3, 0x89, 0xA6, 0xE6, 0x8E, 0x95, 0xAB, 0x86, 0x8C, 0x99, 0x57, 0x70, 0x92, 0x56, 0x65, 0x8F, 0x9E, 0xA0, 0xB2, 0x97, 0xA3, 0xC2, 0x8E, 0xB8, 0xF6, 0x50, 0x78, 0xB4, 0x1D, 0x2D, 0x4E, 0x2D, 0x38, 0x58, 0x45, 0x5F, 0x94, 0x83, 0xB3, 0xF3, 0x80, 0xBA, 0xFA, 0x7F, 0xB7, 0xFA, 0x81, 0xB7, 0xFA, 0x82, 0xB7, 0xF9, 0x81, 0xB8, 0xF9, 0x7E, 0xB7, 0xFA, 0x7E, 0xB7, 0xFB, 0x81, 0xB8, 0xFC, 0x83, 0xB6, 0xFB, 0x80, 0xB6, 0xFA, 0x81, 0xB8, 0xFB, 0x82, 0xB7, 0xFB, 0x82, 0xB8, 0xFB, 0x81, 0xB8, 0xFB, 0x83, 0xB7, 0xFA, 0x83, 0xB8, 0xFB, 0x80, 0xB8, 0xFB, 0x81, 0xB7, 0xFA, 0x83, 0xB9, 0xFC, 0x81, 0xB8, 0xFB, 0x80, 0xB8, 0xF9, 0x7F, 0xB7, 0xF8, 0x80, 0xB7, 0xFB, 0x7F, 0xB5, 0xF8, 0x7B, 0xB1, 0xF6, 0x81, 0xB7, 0xFB, 0x80, 0xB7, 0xFA, 0x7F, 0xB8, 0xFB, 0x7F, 0xB8, 0xFB, 0x7E, 0xB8, 0xFB, 0x7E, 0xB8, 0xFA, 0x7F, 0xB8, 0xFC, 0x82, 0xB7, 0xFC, 0x84, 0xB7, 0xFC, 0x7F, 0xB8, 0xF9, 0x7D, 0xB9, 0xF8, 0x7E, 0xB8, 0xF8, 0x85, 0xB8, 0xF7, 0x8F, 0xAA, 0xDE, 0xA3, 0xAC, 0xC8, 0xAC, 0xBB, 0xD3, 0x91, 0xA7, 0xBB, 0x9E, 0xAB, 0xBE, 0x7B, 0x98, 0xCF, 0x8D, 0xBA, 0xF5, 0x84, 0xB2, 0xE8, 0x89, 0xB1, 0xEB, 0x87, 0xB6, 0xF3, 0x82, 0xB6, 0xF9, 0x7F, 0xB7, 0xF9, 0x80, 0xB8, 0xF7, 0x8E, 0xB0, 0xF2, 0xA6, 0xB3, 0xCB, 0xA1, 0xA8, 0xBB, 0x72, 0x89, 0xB1, 0x33, 0x3E, 0x6A, 0x96, 0x97, 0xAA, 0x9B, 0xAC, 0xCF, 0x89, 0xBD, 0xFD, 0x5C, 0x88, 0xC8, 0x27, 0x36, 0x5C, 0x37, 0x44, 0x69, 0x46, 0x65, 0x9C, 0x80, 0xB1, 0xF3, 0x81, 0xBA, 0xFA, 0x80, 0xB6, 0xFA, 0x82, 0xB8, 0xFD, 0x81, 0xB7, 0xF8, 0x82, 0xB8, 0xF9, 0x7F, 0xB7, 0xFA, 0x7E, 0xB7, 0xFA, 0x80, 0xB8, 0xFB, 0x81, 0xB6, 0xFA, 0x82, 0xB7, 0xFA, 0x82, 0xB7, 0xFA, 0x82, 0xB7, 0xFA, 0x82, 0xB8, 0xFB, 0x81, 0xB9, 0xFB, 0x82, 0xB8, 0xFB, 0x83, 0xB7, 0xFA, 0x81, 0xB8, 0xFA, 0x82, 0xB7, 0xFA, 0x83, 0xB8, 0xFC, 0x83, 0xB7, 0xFB, 0x81, 0xB8, 0xF9, 0x7E, 0xB8, 0xFB, 0x7E, 0xB9, 0xFB, 0x81, 0xB8, 0xFB, 0x83, 0xB6, 0xFB, 0x81, 0xB7, 0xFB, 0x80, 0xB7, 0xFA, 0x7E, 0xB7, 0xFA, 0x7E, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFA, 0x80, 0xB7, 0xFB, 0x81, 0xB7, 0xFB, 0x82, 0xB8, 0xFB, 0x81, 0xB8, 0xF9, 0x7F, 0xB9, 0xF8, 0x7E, 0xB9, 0xFA, 0x87, 0xB9, 0xFA, 0x94, 0xAB, 0xD6, 0x90, 0x9D, 0xB5, 0x9B, 0xB2, 0xDA, 0xA9, 0xC2, 0xE3, 0x7D, 0x8A, 0xA3, 0x73, 0x93, 0xC9, 0x8A, 0xBD, 0xFA, 0x83, 0xB5, 0xF3, 0x8A, 0xB0, 0xE8, 0x8A, 0xB4, 0xEA, 0x83, 0xB7, 0xF6, 0x7E, 0xB8, 0xF9, 0x7F, 0xB9, 0xF7, 0x8C, 0xB2, 0xF4, 0xAA, 0xBC, 0xD6, 0x9F, 0xAA, 0xBD, 0x6A, 0x7D, 0xA3, 0x3B, 0x41, 0x69, 0xA1, 0xA0, 0xB4, 0x9A, 0xAE, 0xD4, 0x83, 0xBE, 0xFD, 0x4D, 0x7C, 0xBB, 0x38, 0x47, 0x70, 0x95, 0xA9, 0xD2, 0x73, 0x98, 0xD2, 0x75, 0xA7, 0xE8, 0x82, 0xB9, 0xFA, 0x80, 0xB6, 0xFB, 0x85, 0xB8, 0xFD, 0x83, 0xB7, 0xFA, 0x82, 0xB7, 0xFB, 0x81, 0xB8, 0xFB, 0x7F, 0xB9, 0xFC, 0x7F, 0xB8, 0xFB, 0x80, 0xB7, 0xFA, 0x82, 0xB9, 0xFB, 0x83, 0xB8, 0xFA, 0x82, 0xB7, 0xF9, 0x82, 0xB8, 0xFA, 0x80, 0xB9, 0xFA, 0x82, 0xB9, 0xFC, 0x81, 0xB8, 0xFA, 0x81, 0xB7, 0xF8, 0x82, 0xB8, 0xFB, 0x83, 0xB8, 0xFC, 0x82, 0xB8, 0xFD };
	
	glGenTextures(1, &texture);
	glBindTexture(GL_TEXTURE_RECTANGLE_ARB, texture);
	glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGB, 64, 64, 0, GL_RGB, GL_UNSIGNED_BYTE, data);
}

- (void)load3DObject
{
	// Für VBOs
	glGenBuffers(1, &vbo);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	
	const float data[] = {
		-1.0f, -1.0f, -1.0f,	0.5f, 0.5f, 0.5f,	0.0f, 0.0f,
		1.0f, -1.0f, 1.0f,		1.0f, 0.5f, 1.0f,	64.0f, 64.0f,
		-1.0f, -1.0f, 1.0f,		0.5f, 0.5f, 1.0f,	0.0f, 64.0f,
		
		-1.0f, -1.0f, -1.0f,	0.5f, 0.5f, 0.5f,	0.0f, 0.0f,
		-1.0f, -1.0f, 1.0f,		0.5f, 0.5f, 1.0f,	0.0f, 64.0f,
		-1.0f, 1.0f, 1.0f,		0.5f, 1.0f, 1.0f,	64.0f, 0.0f,
		
		-1.0f, -1.0f, -1.0f,	0.5f, 0.5f, 0.5f,	0.0f, 0.0f,
		1.0f, -1.0f, 1.0f,		1.0f, 0.5f, 1.0f,	64.0f, 64.0f,
		-1.0f, 1.0f, 1.0f,		0.5f, 1.0f, 1.0f,	64.0f, 0.0f,
		
		-1.0f, -1.0f, 1.0f,		0.5f, 0.5f, 1.0f,	0.0f, 0.0f,
		1.0f, -1.0f, 1.0f,		1.0f, 0.5f, 1.0f,	64.0f, 64.0f,
		-1.0f, 1.0f, 1.0f,		0.5f, 1.0f, 1.0f,	64.0f, 0.0f,
	};
	
	glBufferData(GL_ARRAY_BUFFER, sizeof(data), data, GL_STATIC_DRAW);
	glBindBuffer(GL_ARRAY_BUFFER, 0);
}

- (void)draw3DObject
{
	glLoadIdentity();
	glTranslatef(0.0f, 0.0f, -1.0);
	glRotatef(45.0f, 0.5, 1.0, 2.0);
	
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	glVertexPointer(3, GL_FLOAT, sizeof(float [8]), 0);
	glColorPointer(3, GL_FLOAT, sizeof(float [8]), (const GLvoid *) 12);
	glTexCoordPointer(2, GL_FLOAT, sizeof(float [8]), (const GLvoid *) 20);
	glDrawArrays(GL_TRIANGLES, 0, 12);
	
	glBindBuffer(GL_ARRAY_BUFFER, 0);
}

- (void)loadCoreImage
{
	CGLContextObj cgl_ctx = [[self openGLContext] CGLContextObj];
	ciContext = [[CIContext contextWithCGLContext:cgl_ctx pixelFormat:CGLGetPixelFormat(cgl_ctx) colorSpace:NULL options:nil] retain];
	CIImage *baseImage = [CIImage imageWithTexture:texture size:CGSizeMake(64.0f, 64.0f) flipped:NO colorSpace:nil];
	ciFilter = [[CIFilter filterWithName:@"CIColorInvert"] retain];
	[ciFilter setValue:baseImage forKey:kCIInputImageKey];
		
	glGenTextures(1, &ciTexture);
	glBindTexture(GL_TEXTURE_RECTANGLE_ARB, ciTexture);
	glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGB, 64, 64, 0, GL_RGB, GL_UNSIGNED_BYTE, NULL);
	
	glGenFramebuffersEXT(1, &ciFBO);
}

- (void)drawCoreImage
{
	// GL für Core Image vorbereiten
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_COLOR_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	glViewport(0, 0, 64.0f, 64.0f);
	glOrtho(0.0f, 64.0f, 0.0f, 64.0f, 1.0f, -1.0f);
	glDisable(GL_DEPTH_TEST);
	glDepthMask(GL_FALSE);
	
	glBlendFunc (GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable (GL_BLEND);
	
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, ciFBO);
	glFramebufferTexture2DEXT(GL_FRAMEBUFFER_EXT, GL_COLOR_ATTACHMENT0_EXT, GL_TEXTURE_RECTANGLE_ARB, ciTexture, 0);
	
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT);
	
	// Ausgabe erzeugen und in OpenGL laden
	CIImage *result = [ciFilter valueForKey:kCIOutputImageKey];
	CGRect rect = CGRectMake(0.0f, 0.0f, 64.0f, 64.0f);
	[ciContext drawImage:result inRect:rect fromRect:rect];
	
	// Frame buffer beenden
	glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, 0);

	// Alten Status wieder setzen
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	[self reshape];
	
	// Objekt zeichnen
	glLoadIdentity();
	glTranslatef(1.0f, 0.0f, -1.0f);
	glRotatef(45.0f, 0.5, 1.0, 2.0);
	
	glBindTexture(GL_TEXTURE_RECTANGLE_ARB, ciTexture);
	glBindBuffer(GL_ARRAY_BUFFER, vbo);
	glVertexPointer(3, GL_FLOAT, sizeof(float [8]), 0);
	glColorPointer(3, GL_FLOAT, sizeof(float [8]), (const GLvoid *) 12);
	glTexCoordPointer(2, GL_FLOAT, sizeof(float [8]), (const GLvoid *) 20);
	glDrawArrays(GL_TRIANGLES, 0, 12);
	
	glBindBuffer(GL_ARRAY_BUFFER, 0);
}

@end
